/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.NameAndCodeParser;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandCreateEntityObjectMultilines
extends CommandMultilines2<AbstractClassOrObjectDiagram> {
    private static final Lazy<Pattern2> END = new Lazy<Pattern2>(() -> Pattern2.cmpile("^[%s]*\\}[%s]*$"));

    public CommandCreateEntityObjectMultilines() {
        super(CommandCreateEntityObjectMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH, END);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateEntityObjectMultilines.class.getName(), RegexLeaf.start(), new RegexLeaf(0, "TYPE", "object"), RegexLeaf.spaceOneOrMore(), NameAndCodeParser.nameAndCode(), StereotypePattern.optional("STEREO"), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractClassOrObjectDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        lines = lines.trim().removeEmptyLines();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        Entity entity = this.executeArg0(lines.getLocation(), diagram, line0);
        if (entity == null) {
            return CommandExecutionResult.error("No such entity");
        }
        lines = lines.subExtract(1, 1);
        for (StringLocated s : lines) {
            assert (s.getString().length() > 0);
            if (VisibilityModifier.isVisibilityCharacter(s.getString())) {
                diagram.setVisibilityModifierPresent(true);
            }
            entity.getBodier().addFieldOrMethod(s.getString());
        }
        return CommandExecutionResult.ok();
    }

    private Entity executeArg0(LineLocation location, AbstractClassOrObjectDiagram diagram, RegexResult line0) throws NoSuchColorException {
        String s;
        Entity entity;
        String idShort = diagram.cleanId(line0.getLazzy("CODE", 0));
        Quark<Entity> quark = diagram.quarkInContext(true, idShort);
        String displayString = line0.getLazzy("DISPLAY", 0);
        String stereotype = line0.get("STEREO", 0);
        Display display = Display.getWithNewlines(diagram.getPragma(), displayString);
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(diagram.getPragma(), quark.getName()).withCreoleMode(CreoleMode.SIMPLE_LINE);
        }
        if ((entity = quark.getData()) == null) {
            entity = diagram.reallyCreateLeaf(location, quark, display, LeafType.OBJECT, null);
        }
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s = line0.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        return entity;
    }
}

