/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.utils;

import com.microsoft.windowsazure.core.utils.KeyStoreCredential;
import com.microsoft.windowsazure.core.utils.KeyStoreType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class SSLContextFactory {
    private SSLContextFactory() {
    }

    public static SSLContext create(KeyStoreCredential keyStoreCredential) throws GeneralSecurityException, IOException {
        if (keyStoreCredential == null) {
            throw new IllegalArgumentException("KeyStoreCredential cannot be null.");
        }
        return SSLContextFactory.create(keyStoreCredential.getKeyStorePath(), keyStoreCredential.getKeystorePassword(), keyStoreCredential.getKeyStoreType());
    }

    public static SSLContext create(String keyStorePath, String keyStorePassword, KeyStoreType keyStoreType) throws GeneralSecurityException, IOException {
        if (keyStorePath == null || keyStorePath.isEmpty()) {
            throw new IllegalArgumentException("The keystore path cannot be null or empty.");
        }
        if (keyStoreType == null) {
            throw new IllegalArgumentException("The type of the keystore cannot be null");
        }
        FileInputStream keyStoreInputStream = new FileInputStream(new File(keyStorePath));
        SSLContext sslContext = SSLContext.getInstance("TLS");
        if ((double)Float.valueOf(System.getProperty("java.specification.version")).floatValue() < 1.7 && keyStorePassword != null && keyStorePassword.trim().length() == 0) {
            try {
                String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(defaultAlgorithm);
                Class<?> providerClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                Security.addProvider((Provider)providerClass.newInstance());
                Field field = providerClass.getField("PROVIDER_NAME");
                KeyStore store = KeyStore.getInstance("PKCS12", field.get(null).toString());
                store.load(keyStoreInputStream, keyStorePassword.toCharArray());
                keyManagerFactory.init(store, keyStorePassword.toCharArray());
                sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while initiatlizing SSL contextMake sure java versions less than 1.7 has bouncycastle jar in classpath", e);
            }
        } else {
            KeyManager[] keyManagers = SSLContextFactory.getKeyManagers(keyStoreInputStream, keyStorePassword, keyStoreType);
            sslContext.init(keyManagers, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
        }
        ((InputStream)keyStoreInputStream).close();
        return sslContext;
    }

    private static KeyManager[] getKeyManagers(InputStream keyStoreInputStream, String keyStorePassword, KeyStoreType keyStoreType) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType.name());
        keyStore.load(keyStoreInputStream, keyStorePassword.toCharArray());
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(defaultAlgorithm);
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        return keyManagerFactory.getKeyManagers();
    }
}

