function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { isObject, isNumber } from '../../services/predicate';
var cellPaddingsToClassMap = {
  s: 'ouiDataGridRowCell--paddingSmall',
  m: '',
  l: 'ouiDataGridRowCell--paddingLarge'
};
var fontSizesToClassMap = {
  s: 'ouiDataGridRowCell--fontSizeSmall',
  m: '',
  l: 'ouiDataGridRowCell--fontSizeLarge'
};
function getNumberFromPx(style) {
  return style ? parseInt(style.replace('px', ''), 10) : 0;
}

// So that we use lineCount options we should know exactly row height which allow to show defined line count.
// For this we should know paddings and line height. Because of this we should compute styles for cell with grid styles
export var RowHeightUtils = /*#__PURE__*/function () {
  function RowHeightUtils() {
    _classCallCheck(this, RowHeightUtils);
    _defineProperty(this, "styles", {});
    _defineProperty(this, "fakeCell", document.createElement('div'));
  }
  _createClass(RowHeightUtils, [{
    key: "computeStylesForGridCell",
    value: function computeStylesForGridCell(gridStyles) {
      this.fakeCell.className = "\n      ouiDataGridRowCell\n      ".concat(cellPaddingsToClassMap[gridStyles.cellPadding], "\n      ").concat(fontSizesToClassMap[gridStyles.fontSize], "\n    ");
      document.body.appendChild(this.fakeCell);
      var allStyles = getComputedStyle(this.fakeCell);
      this.styles = {
        paddingTop: allStyles.paddingTop,
        paddingBottom: allStyles.paddingBottom,
        lineHeight: allStyles.lineHeight
      };
      document.body.removeChild(this.fakeCell);
    }
  }, {
    key: "calculateHeightForLineCount",
    value: function calculateHeightForLineCount(lineCount) {
      var paddingTop = getNumberFromPx(this.styles.paddingTop);
      var paddingBottom = getNumberFromPx(this.styles.paddingBottom);
      var lineHeight = getNumberFromPx(this.styles.lineHeight);
      return Math.ceil(lineCount * lineHeight + paddingTop + paddingBottom);
    }
  }, {
    key: "getCalculatedHeight",
    value: function getCalculatedHeight(heightOption, defaultHeight) {
      if (isObject(heightOption)) {
        if (heightOption.lineCount) {
          return this.calculateHeightForLineCount(heightOption.lineCount);
        }
        if (heightOption.height) {
          return Math.max(heightOption.height, defaultHeight);
        }
      }
      if (heightOption && isNumber(heightOption)) {
        return Math.max(heightOption, defaultHeight);
      }
      return defaultHeight;
    }
  }]);
  return RowHeightUtils;
}();
export var getStylesForCell = function getStylesForCell(rowHeightsOptions, rowIndex) {
  var initialHeight = rowHeightsOptions.rowHeights && rowHeightsOptions.rowHeights[rowIndex];
  if (!initialHeight) {
    initialHeight = rowHeightsOptions.defaultHeight;
  }
  if (isObject(initialHeight) && initialHeight.lineCount) {
    return {
      WebkitLineClamp: initialHeight.lineCount,
      display: '-webkit-box',
      WebkitBoxOrient: 'vertical',
      height: '100%',
      overflow: 'hidden',
      flexGrow: 1,
      wordBreak: 'break-all'
    };
  }
  return {
    height: '100%',
    overflow: 'hidden',
    flexGrow: 1,
    wordBreak: 'break-all'
  };
};