/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.analysis.smartcn;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.opensearch.index.analysis.AnalyzerProvider;
import org.opensearch.index.analysis.SmartChineseAnalyzerProvider;
import org.opensearch.index.analysis.SmartChineseNoOpTokenFilterFactory;
import org.opensearch.index.analysis.SmartChineseStopTokenFilterFactory;
import org.opensearch.index.analysis.SmartChineseTokenizerTokenizerFactory;
import org.opensearch.index.analysis.TokenFilterFactory;
import org.opensearch.index.analysis.TokenizerFactory;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.plugins.AnalysisPlugin;
import org.opensearch.plugins.Plugin;

public class AnalysisSmartChinesePlugin
extends Plugin
implements AnalysisPlugin {
    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> tokenFilters = new HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>();
        tokenFilters.put("smartcn_stop", SmartChineseStopTokenFilterFactory::new);
        tokenFilters.put("smartcn_word", SmartChineseNoOpTokenFilterFactory::new);
        return tokenFilters;
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        HashMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> extra = new HashMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>>();
        extra.put("smartcn_tokenizer", SmartChineseTokenizerTokenizerFactory::new);
        extra.put("smartcn_sentence", SmartChineseTokenizerTokenizerFactory::new);
        return extra;
    }

    public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        return Collections.singletonMap("smartcn", SmartChineseAnalyzerProvider::new);
    }
}

