/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.metrics.AsyncConsumerMetrics;
import org.apache.kafka.common.utils.Time;

public class BackgroundEventHandler {
    private final BlockingQueue<BackgroundEvent> backgroundEventQueue;
    private final Time time;
    private final AsyncConsumerMetrics asyncConsumerMetrics;

    public BackgroundEventHandler(BlockingQueue<BackgroundEvent> backgroundEventQueue, Time time, AsyncConsumerMetrics asyncConsumerMetrics) {
        this.backgroundEventQueue = backgroundEventQueue;
        this.time = time;
        this.asyncConsumerMetrics = asyncConsumerMetrics;
    }

    public void add(BackgroundEvent event) {
        Objects.requireNonNull(event, "BackgroundEvent provided to add must be non-null");
        event.setEnqueuedMs(this.time.milliseconds());
        this.asyncConsumerMetrics.recordBackgroundEventQueueSize(this.backgroundEventQueue.size() + 1);
        this.backgroundEventQueue.add(event);
    }

    public List<BackgroundEvent> drainEvents() {
        ArrayList<BackgroundEvent> events = new ArrayList<BackgroundEvent>();
        this.backgroundEventQueue.drainTo(events);
        this.asyncConsumerMetrics.recordBackgroundEventQueueSize(0);
        return events;
    }
}

