'' FreeBASIC binding for curl-7.85.0
''
'' based on the C header files:
''   Copyright (c) 1996 - 2022, Daniel Stenberg, <daniel@haxx.se>, and many
''   contributors, see the THANKS file.
''
''   All rights reserved.
''
''   Permission to use, copy, modify, and distribute this software for any purpose
''   with or without fee is hereby granted, provided that the above copyright
''   notice and this permission notice appear in all copies.
''
''   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
''   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
''   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS. IN
''   NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
''   DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
''   OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
''   OR OTHER DEALINGS IN THE SOFTWARE.
''
''   Except as contained in this notice, the name of a copyright holder shall not
''   be used in advertising or otherwise to promote the sale, use or other dealings
''   in this Software without prior written authorization of the copyright holder.
''
'' translated to FreeBASIC by:
''   FreeBASIC development team

#pragma once

#inclib "curl"

#include once "crt/long.bi"
#include once "crt/stdio.bi"
#include once "crt/limits.bi"
#include once "crt/sys/types.bi"
#include once "crt/time.bi"

#ifdef __FB_WIN32__
	#include once "win/winsock2.bi"
	#include once "win/ws2tcpip.bi"
#else
	#include once "crt/sys/socket.bi"
	#include once "crt/sys/select.bi"
#endif

'' The following symbols have been renamed:
''     enum CURLMSG => CURLMSG_
''     procedure curl_multi_socket => curl_multi_socket_

extern "C"

#define CURLINC_CURL_H
#define CURLINC_CURLVER_H
#define LIBCURL_COPYRIGHT "1996 - 2022 Daniel Stenberg, <daniel@haxx.se>."
#define LIBCURL_VERSION "7.85.0"
const LIBCURL_VERSION_MAJOR = 7
const LIBCURL_VERSION_MINOR = 85
const LIBCURL_VERSION_PATCH = 0
const LIBCURL_VERSION_NUM = &h075500
#define LIBCURL_TIMESTAMP "2022-08-31"
#define CURL_VERSION_BITS(x, y, z) ((((x) shl 16) or ((y) shl 8)) or (z))
#define CURL_AT_LEAST_VERSION(x, y, z) (LIBCURL_VERSION_NUM >= CURL_VERSION_BITS(x, y, z))
#define CURLINC_SYSTEM_H

#if defined(__FB_DOS__) or ((not defined(__FB_64BIT__)) and defined(__FB_UNIX__))
	#define CURL_FORMAT_CURL_OFF_T "lld"
	#define CURL_FORMAT_CURL_OFF_TU "llu"
#elseif defined(__FB_64BIT__) and defined(__FB_UNIX__)
	#define CURL_FORMAT_CURL_OFF_T "ld"
	#define CURL_FORMAT_CURL_OFF_TU "lu"
#else
	#define CURL_FORMAT_CURL_OFF_T "I64d"
	#define CURL_FORMAT_CURL_OFF_TU "I64u"
#endif

#define CURL_SUFFIX_CURL_OFF_T LL
#define CURL_SUFFIX_CURL_OFF_TU ULL

#ifdef __FB_DOS__
	type curl_socklen_t as long
#else
	type curl_socklen_t as socklen_t
#endif

type curl_off_t as longint
#define CURL_ISOCPP
#define CURLINC_OFF_T_C_HLPR2(Val, Suffix) Val##Suffix
#define CURLINC_OFF_T_C_HLPR1(Val, Suffix) CURLINC_OFF_T_C_HLPR2(Val, Suffix)
#define CURL_OFF_T_C(Val) CURLINC_OFF_T_C_HLPR1(Val, CURL_SUFFIX_CURL_OFF_T)
#define CURL_OFF_TU_C(Val) CURLINC_OFF_T_C_HLPR1(Val, CURL_SUFFIX_CURL_OFF_TU)
type CURL as any
type CURLSH as any

#ifdef __FB_WIN32__
	type curl_socket_t as SOCKET
	#define CURL_SOCKET_BAD INVALID_SOCKET
#else
	type curl_socket_t as long
	const CURL_SOCKET_BAD = -1
#endif

#define curl_socket_typedef

type curl_sslbackend as long
enum
	CURLSSLBACKEND_NONE = 0
	CURLSSLBACKEND_OPENSSL = 1
	CURLSSLBACKEND_GNUTLS = 2
	CURLSSLBACKEND_NSS = 3
	CURLSSLBACKEND_OBSOLETE4 = 4
	CURLSSLBACKEND_GSKIT = 5
	CURLSSLBACKEND_POLARSSL = 6
	CURLSSLBACKEND_WOLFSSL = 7
	CURLSSLBACKEND_SCHANNEL = 8
	CURLSSLBACKEND_SECURETRANSPORT = 9
	CURLSSLBACKEND_AXTLS = 10
	CURLSSLBACKEND_MBEDTLS = 11
	CURLSSLBACKEND_MESALINK = 12
	CURLSSLBACKEND_BEARSSL = 13
	CURLSSLBACKEND_RUSTLS = 14
end enum

const CURLSSLBACKEND_LIBRESSL = CURLSSLBACKEND_OPENSSL
const CURLSSLBACKEND_BORINGSSL = CURLSSLBACKEND_OPENSSL
const CURLSSLBACKEND_CYASSL = CURLSSLBACKEND_WOLFSSL
const CURLSSLBACKEND_DARWINSSL = CURLSSLBACKEND_SECURETRANSPORT
type curl_slist as curl_slist_

type curl_httppost
	next as curl_httppost ptr
	name as zstring ptr
	namelength as clong
	contents as zstring ptr
	contentslength as clong
	buffer as zstring ptr
	bufferlength as clong
	contenttype as zstring ptr
	contentheader as curl_slist ptr
	more as curl_httppost ptr
	flags as clong
	showfilename as zstring ptr
	userp as any ptr
	contentlen as curl_off_t
end type

const CURL_HTTPPOST_FILENAME = 1 shl 0
const CURL_HTTPPOST_READFILE = 1 shl 1
const CURL_HTTPPOST_PTRNAME = 1 shl 2
const CURL_HTTPPOST_PTRCONTENTS = 1 shl 3
const CURL_HTTPPOST_BUFFER = 1 shl 4
const CURL_HTTPPOST_PTRBUFFER = 1 shl 5
const CURL_HTTPPOST_CALLBACK = 1 shl 6
const CURL_HTTPPOST_LARGE = 1 shl 7
const CURL_PROGRESSFUNC_CONTINUE = &h10000001
type curl_progress_callback as function(byval clientp as any ptr, byval dltotal as double, byval dlnow as double, byval ultotal as double, byval ulnow as double) as long
type curl_xferinfo_callback as function(byval clientp as any ptr, byval dltotal as curl_off_t, byval dlnow as curl_off_t, byval ultotal as curl_off_t, byval ulnow as curl_off_t) as long
const CURL_MAX_READ_SIZE = 524288
const CURL_MAX_WRITE_SIZE = 16384
const CURL_MAX_HTTP_HEADER = 100 * 1024
const CURL_WRITEFUNC_PAUSE = &h10000001
type curl_write_callback as function(byval buffer as zstring ptr, byval size as uinteger, byval nitems as uinteger, byval outstream as any ptr) as uinteger
type curl_resolver_start_callback as function(byval resolver_state as any ptr, byval reserved as any ptr, byval userdata as any ptr) as long

type curlfiletype as long
enum
	CURLFILETYPE_FILE = 0
	CURLFILETYPE_DIRECTORY
	CURLFILETYPE_SYMLINK
	CURLFILETYPE_DEVICE_BLOCK
	CURLFILETYPE_DEVICE_CHAR
	CURLFILETYPE_NAMEDPIPE
	CURLFILETYPE_SOCKET
	CURLFILETYPE_DOOR
	CURLFILETYPE_UNKNOWN
end enum

const CURLFINFOFLAG_KNOWN_FILENAME = 1 shl 0
const CURLFINFOFLAG_KNOWN_FILETYPE = 1 shl 1
const CURLFINFOFLAG_KNOWN_TIME = 1 shl 2
const CURLFINFOFLAG_KNOWN_PERM = 1 shl 3
const CURLFINFOFLAG_KNOWN_UID = 1 shl 4
const CURLFINFOFLAG_KNOWN_GID = 1 shl 5
const CURLFINFOFLAG_KNOWN_SIZE = 1 shl 6
const CURLFINFOFLAG_KNOWN_HLINKCOUNT = 1 shl 7

type curl_fileinfo_strings
	time as zstring ptr
	perm as zstring ptr
	user as zstring ptr
	group as zstring ptr
	target as zstring ptr
end type

type curl_fileinfo
	filename as zstring ptr
	filetype as curlfiletype
	time as time_t
	perm as ulong
	uid as long
	gid as long
	size as curl_off_t
	hardlinks as clong
	strings as curl_fileinfo_strings
	flags as ulong
	b_data as zstring ptr
	b_size as uinteger
	b_used as uinteger
end type

const CURL_CHUNK_BGN_FUNC_OK = 0
const CURL_CHUNK_BGN_FUNC_FAIL = 1
const CURL_CHUNK_BGN_FUNC_SKIP = 2
type curl_chunk_bgn_callback as function(byval transfer_info as const any ptr, byval ptr as any ptr, byval remains as long) as clong
const CURL_CHUNK_END_FUNC_OK = 0
const CURL_CHUNK_END_FUNC_FAIL = 1
type curl_chunk_end_callback as function(byval ptr as any ptr) as clong
const CURL_FNMATCHFUNC_MATCH = 0
const CURL_FNMATCHFUNC_NOMATCH = 1
const CURL_FNMATCHFUNC_FAIL = 2
type curl_fnmatch_callback as function(byval ptr as any ptr, byval pattern as const zstring ptr, byval string as const zstring ptr) as long
const CURL_SEEKFUNC_OK = 0
const CURL_SEEKFUNC_FAIL = 1
const CURL_SEEKFUNC_CANTSEEK = 2
type curl_seek_callback as function(byval instream as any ptr, byval offset as curl_off_t, byval origin as long) as long
const CURL_READFUNC_ABORT = &h10000000
const CURL_READFUNC_PAUSE = &h10000001
const CURL_TRAILERFUNC_OK = 0
const CURL_TRAILERFUNC_ABORT = 1
type curl_read_callback as function(byval buffer as zstring ptr, byval size as uinteger, byval nitems as uinteger, byval instream as any ptr) as uinteger
type curl_trailer_callback as function(byval list as curl_slist ptr ptr, byval userdata as any ptr) as long

type curlsocktype as long
enum
	CURLSOCKTYPE_IPCXN
	CURLSOCKTYPE_ACCEPT
	CURLSOCKTYPE_LAST
end enum

const CURL_SOCKOPT_OK = 0
const CURL_SOCKOPT_ERROR = 1
const CURL_SOCKOPT_ALREADY_CONNECTED = 2
type curl_sockopt_callback as function(byval clientp as any ptr, byval curlfd as curl_socket_t, byval purpose as curlsocktype) as long

type curl_sockaddr
	family as long
	socktype as long
	protocol as long
	addrlen as ulong
	addr as sockaddr
end type

type curl_opensocket_callback as function(byval clientp as any ptr, byval purpose as curlsocktype, byval address as curl_sockaddr ptr) as curl_socket_t
type curl_closesocket_callback as function(byval clientp as any ptr, byval item as curl_socket_t) as long

type curlioerr as long
enum
	CURLIOE_OK
	CURLIOE_UNKNOWNCMD
	CURLIOE_FAILRESTART
	CURLIOE_LAST
end enum

type curliocmd as long
enum
	CURLIOCMD_NOP
	CURLIOCMD_RESTARTREAD
	CURLIOCMD_LAST
end enum

type curl_ioctl_callback as function(byval handle as CURL ptr, byval cmd as long, byval clientp as any ptr) as curlioerr
type curl_malloc_callback as function(byval size as uinteger) as any ptr
type curl_free_callback as sub(byval ptr as any ptr)
type curl_realloc_callback as function(byval ptr as any ptr, byval size as uinteger) as any ptr
type curl_strdup_callback as function(byval str as const zstring ptr) as zstring ptr
type curl_calloc_callback as function(byval nmemb as uinteger, byval size as uinteger) as any ptr

type curl_infotype as long
enum
	CURLINFO_TEXT = 0
	CURLINFO_HEADER_IN
	CURLINFO_HEADER_OUT
	CURLINFO_DATA_IN
	CURLINFO_DATA_OUT
	CURLINFO_SSL_DATA_IN
	CURLINFO_SSL_DATA_OUT
	CURLINFO_END
end enum

type curl_debug_callback as function(byval handle as CURL ptr, byval type as curl_infotype, byval data as zstring ptr, byval size as uinteger, byval userptr as any ptr) as long
type curl_prereq_callback as function(byval clientp as any ptr, byval conn_primary_ip as zstring ptr, byval conn_local_ip as zstring ptr, byval conn_primary_port as long, byval conn_local_port as long) as long
const CURL_PREREQFUNC_OK = 0
const CURL_PREREQFUNC_ABORT = 1

type CURLcode as long
enum
	CURLE_OK = 0
	CURLE_UNSUPPORTED_PROTOCOL
	CURLE_FAILED_INIT
	CURLE_URL_MALFORMAT
	CURLE_NOT_BUILT_IN
	CURLE_COULDNT_RESOLVE_PROXY
	CURLE_COULDNT_RESOLVE_HOST
	CURLE_COULDNT_CONNECT
	CURLE_WEIRD_SERVER_REPLY
	CURLE_REMOTE_ACCESS_DENIED
	CURLE_FTP_ACCEPT_FAILED
	CURLE_FTP_WEIRD_PASS_REPLY
	CURLE_FTP_ACCEPT_TIMEOUT
	CURLE_FTP_WEIRD_PASV_REPLY
	CURLE_FTP_WEIRD_227_FORMAT
	CURLE_FTP_CANT_GET_HOST
	CURLE_HTTP2
	CURLE_FTP_COULDNT_SET_TYPE
	CURLE_PARTIAL_FILE
	CURLE_FTP_COULDNT_RETR_FILE
	CURLE_OBSOLETE20
	CURLE_QUOTE_ERROR
	CURLE_HTTP_RETURNED_ERROR
	CURLE_WRITE_ERROR
	CURLE_OBSOLETE24
	CURLE_UPLOAD_FAILED
	CURLE_READ_ERROR
	CURLE_OUT_OF_MEMORY
	CURLE_OPERATION_TIMEDOUT
	CURLE_OBSOLETE29
	CURLE_FTP_PORT_FAILED
	CURLE_FTP_COULDNT_USE_REST
	CURLE_OBSOLETE32
	CURLE_RANGE_ERROR
	CURLE_HTTP_POST_ERROR
	CURLE_SSL_CONNECT_ERROR
	CURLE_BAD_DOWNLOAD_RESUME
	CURLE_FILE_COULDNT_READ_FILE
	CURLE_LDAP_CANNOT_BIND
	CURLE_LDAP_SEARCH_FAILED
	CURLE_OBSOLETE40
	CURLE_FUNCTION_NOT_FOUND
	CURLE_ABORTED_BY_CALLBACK
	CURLE_BAD_FUNCTION_ARGUMENT
	CURLE_OBSOLETE44
	CURLE_INTERFACE_FAILED
	CURLE_OBSOLETE46
	CURLE_TOO_MANY_REDIRECTS
	CURLE_UNKNOWN_OPTION
	CURLE_SETOPT_OPTION_SYNTAX
	CURLE_OBSOLETE50
	CURLE_OBSOLETE51
	CURLE_GOT_NOTHING
	CURLE_SSL_ENGINE_NOTFOUND
	CURLE_SSL_ENGINE_SETFAILED
	CURLE_SEND_ERROR
	CURLE_RECV_ERROR
	CURLE_OBSOLETE57
	CURLE_SSL_CERTPROBLEM
	CURLE_SSL_CIPHER
	CURLE_PEER_FAILED_VERIFICATION
	CURLE_BAD_CONTENT_ENCODING
	CURLE_OBSOLETE62
	CURLE_FILESIZE_EXCEEDED
	CURLE_USE_SSL_FAILED
	CURLE_SEND_FAIL_REWIND
	CURLE_SSL_ENGINE_INITFAILED
	CURLE_LOGIN_DENIED
	CURLE_TFTP_NOTFOUND
	CURLE_TFTP_PERM
	CURLE_REMOTE_DISK_FULL
	CURLE_TFTP_ILLEGAL
	CURLE_TFTP_UNKNOWNID
	CURLE_REMOTE_FILE_EXISTS
	CURLE_TFTP_NOSUCHUSER
	CURLE_OBSOLETE75
	CURLE_OBSOLETE76
	CURLE_SSL_CACERT_BADFILE
	CURLE_REMOTE_FILE_NOT_FOUND
	CURLE_SSH
	CURLE_SSL_SHUTDOWN_FAILED
	CURLE_AGAIN
	CURLE_SSL_CRL_BADFILE
	CURLE_SSL_ISSUER_ERROR
	CURLE_FTP_PRET_FAILED
	CURLE_RTSP_CSEQ_ERROR
	CURLE_RTSP_SESSION_ERROR
	CURLE_FTP_BAD_FILE_LIST
	CURLE_CHUNK_FAILED
	CURLE_NO_CONNECTION_AVAILABLE
	CURLE_SSL_PINNEDPUBKEYNOTMATCH
	CURLE_SSL_INVALIDCERTSTATUS
	CURLE_HTTP2_STREAM
	CURLE_RECURSIVE_API_CALL
	CURLE_AUTH_ERROR
	CURLE_HTTP3
	CURLE_QUIC_CONNECT_ERROR
	CURLE_PROXY
	CURLE_SSL_CLIENTCERT
	CURLE_UNRECOVERABLE_POLL
	CURL_LAST
end enum

const CURLE_OBSOLETE16 = CURLE_HTTP2
const CURLE_OBSOLETE10 = CURLE_FTP_ACCEPT_FAILED
const CURLE_OBSOLETE12 = CURLE_FTP_ACCEPT_TIMEOUT
const CURLE_FTP_WEIRD_SERVER_REPLY = CURLE_WEIRD_SERVER_REPLY
const CURLE_SSL_CACERT = CURLE_PEER_FAILED_VERIFICATION
const CURLE_UNKNOWN_TELNET_OPTION = CURLE_UNKNOWN_OPTION
const CURLE_TELNET_OPTION_SYNTAX = CURLE_SETOPT_OPTION_SYNTAX
const CURLE_SSL_PEER_CERTIFICATE = CURLE_PEER_FAILED_VERIFICATION
const CURLE_OBSOLETE = CURLE_OBSOLETE50
const CURLE_BAD_PASSWORD_ENTERED = CURLE_OBSOLETE46
const CURLE_BAD_CALLING_ORDER = CURLE_OBSOLETE44
const CURLE_FTP_USER_PASSWORD_INCORRECT = CURLE_OBSOLETE10
const CURLE_FTP_CANT_RECONNECT = CURLE_OBSOLETE16
const CURLE_FTP_COULDNT_GET_SIZE = CURLE_OBSOLETE32
const CURLE_FTP_COULDNT_SET_ASCII = CURLE_OBSOLETE29
const CURLE_FTP_WEIRD_USER_REPLY = CURLE_OBSOLETE12
const CURLE_FTP_WRITE_ERROR = CURLE_OBSOLETE20
const CURLE_LIBRARY_NOT_FOUND = CURLE_OBSOLETE40
const CURLE_MALFORMAT_USER = CURLE_OBSOLETE24
const CURLE_SHARE_IN_USE = CURLE_OBSOLETE57
const CURLE_URL_MALFORMAT_USER = CURLE_NOT_BUILT_IN
const CURLE_FTP_ACCESS_DENIED = CURLE_REMOTE_ACCESS_DENIED
const CURLE_FTP_COULDNT_SET_BINARY = CURLE_FTP_COULDNT_SET_TYPE
const CURLE_FTP_QUOTE_ERROR = CURLE_QUOTE_ERROR
const CURLE_TFTP_DISKFULL = CURLE_REMOTE_DISK_FULL
const CURLE_TFTP_EXISTS = CURLE_REMOTE_FILE_EXISTS
const CURLE_HTTP_RANGE_ERROR = CURLE_RANGE_ERROR
const CURLE_FTP_SSL_FAILED = CURLE_USE_SSL_FAILED
const CURLE_OPERATION_TIMEOUTED = CURLE_OPERATION_TIMEDOUT
const CURLE_HTTP_NOT_FOUND = CURLE_HTTP_RETURNED_ERROR
const CURLE_HTTP_PORT_FAILED = CURLE_INTERFACE_FAILED
const CURLE_FTP_COULDNT_STOR_FILE = CURLE_UPLOAD_FAILED
const CURLE_FTP_PARTIAL_FILE = CURLE_PARTIAL_FILE
const CURLE_FTP_BAD_DOWNLOAD_RESUME = CURLE_BAD_DOWNLOAD_RESUME
const CURLE_LDAP_INVALID_URL = CURLE_OBSOLETE62
const CURLE_CONV_REQD = CURLE_OBSOLETE76
const CURLE_CONV_FAILED = CURLE_OBSOLETE75
const CURLE_ALREADY_COMPLETE = 99999

type CURLproxycode as long
enum
	CURLPX_OK
	CURLPX_BAD_ADDRESS_TYPE
	CURLPX_BAD_VERSION
	CURLPX_CLOSED
	CURLPX_GSSAPI
	CURLPX_GSSAPI_PERMSG
	CURLPX_GSSAPI_PROTECTION
	CURLPX_IDENTD
	CURLPX_IDENTD_DIFFER
	CURLPX_LONG_HOSTNAME
	CURLPX_LONG_PASSWD
	CURLPX_LONG_USER
	CURLPX_NO_AUTH
	CURLPX_RECV_ADDRESS
	CURLPX_RECV_AUTH
	CURLPX_RECV_CONNECT
	CURLPX_RECV_REQACK
	CURLPX_REPLY_ADDRESS_TYPE_NOT_SUPPORTED
	CURLPX_REPLY_COMMAND_NOT_SUPPORTED
	CURLPX_REPLY_CONNECTION_REFUSED
	CURLPX_REPLY_GENERAL_SERVER_FAILURE
	CURLPX_REPLY_HOST_UNREACHABLE
	CURLPX_REPLY_NETWORK_UNREACHABLE
	CURLPX_REPLY_NOT_ALLOWED
	CURLPX_REPLY_TTL_EXPIRED
	CURLPX_REPLY_UNASSIGNED
	CURLPX_REQUEST_FAILED
	CURLPX_RESOLVE_HOST
	CURLPX_SEND_AUTH
	CURLPX_SEND_CONNECT
	CURLPX_SEND_REQUEST
	CURLPX_UNKNOWN_FAIL
	CURLPX_UNKNOWN_MODE
	CURLPX_USER_REJECTED
	CURLPX_LAST
end enum

type curl_conv_callback as function(byval buffer as zstring ptr, byval length as uinteger) as CURLcode
type curl_ssl_ctx_callback as function(byval curl as CURL ptr, byval ssl_ctx as any ptr, byval userptr as any ptr) as CURLcode

type curl_proxytype as long
enum
	CURLPROXY_HTTP = 0
	CURLPROXY_HTTP_1_0 = 1
	CURLPROXY_HTTPS = 2
	CURLPROXY_SOCKS4 = 4
	CURLPROXY_SOCKS5 = 5
	CURLPROXY_SOCKS4A = 6
	CURLPROXY_SOCKS5_HOSTNAME = 7
end enum

const CURLAUTH_NONE = cast(culong, 0)
const CURLAUTH_BASIC = cast(culong, 1) shl 0
const CURLAUTH_DIGEST = cast(culong, 1) shl 1
const CURLAUTH_NEGOTIATE = cast(culong, 1) shl 2
const CURLAUTH_GSSNEGOTIATE = CURLAUTH_NEGOTIATE
const CURLAUTH_GSSAPI = CURLAUTH_NEGOTIATE
const CURLAUTH_NTLM = cast(culong, 1) shl 3
const CURLAUTH_DIGEST_IE = cast(culong, 1) shl 4
const CURLAUTH_NTLM_WB = cast(culong, 1) shl 5
const CURLAUTH_BEARER = cast(culong, 1) shl 6
const CURLAUTH_AWS_SIGV4 = cast(culong, 1) shl 7
const CURLAUTH_ONLY = cast(culong, 1) shl 31
const CURLAUTH_ANY = not CURLAUTH_DIGEST_IE
const CURLAUTH_ANYSAFE = not (CURLAUTH_BASIC or CURLAUTH_DIGEST_IE)
const CURLSSH_AUTH_ANY = not 0
const CURLSSH_AUTH_NONE = 0
const CURLSSH_AUTH_PUBLICKEY = 1 shl 0
const CURLSSH_AUTH_PASSWORD = 1 shl 1
const CURLSSH_AUTH_HOST = 1 shl 2
const CURLSSH_AUTH_KEYBOARD = 1 shl 3
const CURLSSH_AUTH_AGENT = 1 shl 4
const CURLSSH_AUTH_GSSAPI = 1 shl 5
const CURLSSH_AUTH_DEFAULT = CURLSSH_AUTH_ANY
const CURLGSSAPI_DELEGATION_NONE = 0
const CURLGSSAPI_DELEGATION_POLICY_FLAG = 1 shl 0
const CURLGSSAPI_DELEGATION_FLAG = 1 shl 1
const CURL_ERROR_SIZE = 256

type curl_khtype as long
enum
	CURLKHTYPE_UNKNOWN
	CURLKHTYPE_RSA1
	CURLKHTYPE_RSA
	CURLKHTYPE_DSS
	CURLKHTYPE_ECDSA
	CURLKHTYPE_ED25519
end enum

type curl_khkey
	key as const zstring ptr
	len as uinteger
	keytype as curl_khtype
end type

type curl_khstat as long
enum
	CURLKHSTAT_FINE_ADD_TO_FILE
	CURLKHSTAT_FINE
	CURLKHSTAT_REJECT
	CURLKHSTAT_DEFER
	CURLKHSTAT_FINE_REPLACE
	CURLKHSTAT_LAST
end enum

type curl_khmatch as long
enum
	CURLKHMATCH_OK
	CURLKHMATCH_MISMATCH
	CURLKHMATCH_MISSING
	CURLKHMATCH_LAST
end enum

type curl_sshkeycallback as function(byval easy as CURL ptr, byval knownkey as const curl_khkey ptr, byval foundkey as const curl_khkey ptr, byval as curl_khmatch, byval clientp as any ptr) as long
type curl_sshhostkeycallback as function(byval clientp as any ptr, byval keytype as long, byval key as const zstring ptr, byval keylen as uinteger) as long

type curl_usessl as long
enum
	CURLUSESSL_NONE
	CURLUSESSL_TRY
	CURLUSESSL_CONTROL
	CURLUSESSL_ALL
	CURLUSESSL_LAST
end enum

const CURLSSLOPT_ALLOW_BEAST = 1 shl 0
const CURLSSLOPT_NO_REVOKE = 1 shl 1
const CURLSSLOPT_NO_PARTIALCHAIN = 1 shl 2
const CURLSSLOPT_REVOKE_BEST_EFFORT = 1 shl 3
const CURLSSLOPT_NATIVE_CA = 1 shl 4
const CURLSSLOPT_AUTO_CLIENT_CERT = 1 shl 5
const CURL_HET_DEFAULT = cast(clong, 200)
const CURL_UPKEEP_INTERVAL_DEFAULT = cast(clong, 60000)
const CURLFTPSSL_NONE = CURLUSESSL_NONE
const CURLFTPSSL_TRY = CURLUSESSL_TRY
const CURLFTPSSL_CONTROL = CURLUSESSL_CONTROL
const CURLFTPSSL_ALL = CURLUSESSL_ALL
const CURLFTPSSL_LAST = CURLUSESSL_LAST
type curl_ftpssl as curl_usessl

type curl_ftpccc as long
enum
	CURLFTPSSL_CCC_NONE
	CURLFTPSSL_CCC_PASSIVE
	CURLFTPSSL_CCC_ACTIVE
	CURLFTPSSL_CCC_LAST
end enum

type curl_ftpauth as long
enum
	CURLFTPAUTH_DEFAULT
	CURLFTPAUTH_SSL
	CURLFTPAUTH_TLS
	CURLFTPAUTH_LAST
end enum

type curl_ftpcreatedir as long
enum
	CURLFTP_CREATE_DIR_NONE
	CURLFTP_CREATE_DIR
	CURLFTP_CREATE_DIR_RETRY
	CURLFTP_CREATE_DIR_LAST
end enum

type curl_ftpmethod as long
enum
	CURLFTPMETHOD_DEFAULT
	CURLFTPMETHOD_MULTICWD
	CURLFTPMETHOD_NOCWD
	CURLFTPMETHOD_SINGLECWD
	CURLFTPMETHOD_LAST
end enum

const CURLHEADER_UNIFIED = 0
const CURLHEADER_SEPARATE = 1 shl 0
const CURLALTSVC_READONLYFILE = 1 shl 2
const CURLALTSVC_H1 = 1 shl 3
const CURLALTSVC_H2 = 1 shl 4
const CURLALTSVC_H3 = 1 shl 5

type curl_hstsentry
	name as zstring ptr
	namelen as uinteger
	includeSubDomains : 1 as ulong
	expire as zstring * 18
end type

type curl_index
	index as uinteger
	total as uinteger
end type

type CURLSTScode as long
enum
	CURLSTS_OK
	CURLSTS_DONE
	CURLSTS_FAIL
end enum

type curl_hstsread_callback as function(byval easy as CURL ptr, byval e as curl_hstsentry ptr, byval userp as any ptr) as CURLSTScode
type curl_hstswrite_callback as function(byval easy as CURL ptr, byval e as curl_hstsentry ptr, byval i as curl_index ptr, byval userp as any ptr) as CURLSTScode
const CURLHSTS_ENABLE = cast(clong, 1 shl 0)
const CURLHSTS_READONLYFILE = cast(clong, 1 shl 1)
const CURLPROTO_HTTP = 1 shl 0
const CURLPROTO_HTTPS = 1 shl 1
const CURLPROTO_FTP = 1 shl 2
const CURLPROTO_FTPS = 1 shl 3
const CURLPROTO_SCP = 1 shl 4
const CURLPROTO_SFTP = 1 shl 5
const CURLPROTO_TELNET = 1 shl 6
const CURLPROTO_LDAP = 1 shl 7
const CURLPROTO_LDAPS = 1 shl 8
const CURLPROTO_DICT = 1 shl 9
const CURLPROTO_FILE = 1 shl 10
const CURLPROTO_TFTP = 1 shl 11
const CURLPROTO_IMAP = 1 shl 12
const CURLPROTO_IMAPS = 1 shl 13
const CURLPROTO_POP3 = 1 shl 14
const CURLPROTO_POP3S = 1 shl 15
const CURLPROTO_SMTP = 1 shl 16
const CURLPROTO_SMTPS = 1 shl 17
const CURLPROTO_RTSP = 1 shl 18
const CURLPROTO_RTMP = 1 shl 19
const CURLPROTO_RTMPT = 1 shl 20
const CURLPROTO_RTMPE = 1 shl 21
const CURLPROTO_RTMPTE = 1 shl 22
const CURLPROTO_RTMPS = 1 shl 23
const CURLPROTO_RTMPTS = 1 shl 24
const CURLPROTO_GOPHER = 1 shl 25
const CURLPROTO_SMB = 1 shl 26
const CURLPROTO_SMBS = 1 shl 27
const CURLPROTO_MQTT = 1 shl 28
const CURLPROTO_GOPHERS = 1 shl 29
const CURLPROTO_ALL = not 0
const CURLOPTTYPE_LONG = 0
const CURLOPTTYPE_OBJECTPOINT = 10000
const CURLOPTTYPE_FUNCTIONPOINT = 20000
const CURLOPTTYPE_OFF_T = 30000
const CURLOPTTYPE_BLOB = 40000
#define CURLOPT(na, t, nu) scope : na = t + nu : end scope
const CURLOPTTYPE_STRINGPOINT = CURLOPTTYPE_OBJECTPOINT
const CURLOPTTYPE_SLISTPOINT = CURLOPTTYPE_OBJECTPOINT
const CURLOPTTYPE_CBPOINT = CURLOPTTYPE_OBJECTPOINT
const CURLOPTTYPE_VALUES = CURLOPTTYPE_LONG

type CURLoption as long
enum
	CURLOPT_WRITEDATA = CURLOPTTYPE_OBJECTPOINT + 1
	CURLOPT_URL = CURLOPTTYPE_OBJECTPOINT + 2
	CURLOPT_PORT = CURLOPTTYPE_LONG + 3
	CURLOPT_PROXY = CURLOPTTYPE_OBJECTPOINT + 4
	CURLOPT_USERPWD = CURLOPTTYPE_OBJECTPOINT + 5
	CURLOPT_PROXYUSERPWD = CURLOPTTYPE_OBJECTPOINT + 6
	CURLOPT_RANGE = CURLOPTTYPE_OBJECTPOINT + 7
	CURLOPT_READDATA = CURLOPTTYPE_OBJECTPOINT + 9
	CURLOPT_ERRORBUFFER = CURLOPTTYPE_OBJECTPOINT + 10
	CURLOPT_WRITEFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 11
	CURLOPT_READFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 12
	CURLOPT_TIMEOUT = CURLOPTTYPE_LONG + 13
	CURLOPT_INFILESIZE = CURLOPTTYPE_LONG + 14
	CURLOPT_POSTFIELDS = CURLOPTTYPE_OBJECTPOINT + 15
	CURLOPT_REFERER = CURLOPTTYPE_OBJECTPOINT + 16
	CURLOPT_FTPPORT = CURLOPTTYPE_OBJECTPOINT + 17
	CURLOPT_USERAGENT = CURLOPTTYPE_OBJECTPOINT + 18
	CURLOPT_LOW_SPEED_LIMIT = CURLOPTTYPE_LONG + 19
	CURLOPT_LOW_SPEED_TIME = CURLOPTTYPE_LONG + 20
	CURLOPT_RESUME_FROM = CURLOPTTYPE_LONG + 21
	CURLOPT_COOKIE = CURLOPTTYPE_OBJECTPOINT + 22
	CURLOPT_HTTPHEADER = CURLOPTTYPE_OBJECTPOINT + 23
	CURLOPT_HTTPPOST = CURLOPTTYPE_OBJECTPOINT + 24
	CURLOPT_SSLCERT = CURLOPTTYPE_OBJECTPOINT + 25
	CURLOPT_KEYPASSWD = CURLOPTTYPE_OBJECTPOINT + 26
	CURLOPT_CRLF = CURLOPTTYPE_LONG + 27
	CURLOPT_QUOTE = CURLOPTTYPE_OBJECTPOINT + 28
	CURLOPT_HEADERDATA = CURLOPTTYPE_OBJECTPOINT + 29
	CURLOPT_COOKIEFILE = CURLOPTTYPE_OBJECTPOINT + 31
	CURLOPT_SSLVERSION = CURLOPTTYPE_LONG + 32
	CURLOPT_TIMECONDITION = CURLOPTTYPE_LONG + 33
	CURLOPT_TIMEVALUE = CURLOPTTYPE_LONG + 34
	CURLOPT_CUSTOMREQUEST = CURLOPTTYPE_OBJECTPOINT + 36
	CURLOPT_STDERR = CURLOPTTYPE_OBJECTPOINT + 37
	CURLOPT_POSTQUOTE = CURLOPTTYPE_OBJECTPOINT + 39
	CURLOPT_OBSOLETE40 = CURLOPTTYPE_OBJECTPOINT + 40
	CURLOPT_VERBOSE = CURLOPTTYPE_LONG + 41
	CURLOPT_HEADER = CURLOPTTYPE_LONG + 42
	CURLOPT_NOPROGRESS = CURLOPTTYPE_LONG + 43
	CURLOPT_NOBODY = CURLOPTTYPE_LONG + 44
	CURLOPT_FAILONERROR = CURLOPTTYPE_LONG + 45
	CURLOPT_UPLOAD = CURLOPTTYPE_LONG + 46
	CURLOPT_POST = CURLOPTTYPE_LONG + 47
	CURLOPT_DIRLISTONLY = CURLOPTTYPE_LONG + 48
	CURLOPT_APPEND = CURLOPTTYPE_LONG + 50
	CURLOPT_NETRC = CURLOPTTYPE_LONG + 51
	CURLOPT_FOLLOWLOCATION = CURLOPTTYPE_LONG + 52
	CURLOPT_TRANSFERTEXT = CURLOPTTYPE_LONG + 53
	CURLOPT_PUT = CURLOPTTYPE_LONG + 54
	CURLOPT_PROGRESSFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 56
	CURLOPT_XFERINFODATA = CURLOPTTYPE_OBJECTPOINT + 57
	CURLOPT_AUTOREFERER = CURLOPTTYPE_LONG + 58
	CURLOPT_PROXYPORT = CURLOPTTYPE_LONG + 59
	CURLOPT_POSTFIELDSIZE = CURLOPTTYPE_LONG + 60
	CURLOPT_HTTPPROXYTUNNEL = CURLOPTTYPE_LONG + 61
	CURLOPT_INTERFACE = CURLOPTTYPE_OBJECTPOINT + 62
	CURLOPT_KRBLEVEL = CURLOPTTYPE_OBJECTPOINT + 63
	CURLOPT_SSL_VERIFYPEER = CURLOPTTYPE_LONG + 64
	CURLOPT_CAINFO = CURLOPTTYPE_OBJECTPOINT + 65
	CURLOPT_MAXREDIRS = CURLOPTTYPE_LONG + 68
	CURLOPT_FILETIME = CURLOPTTYPE_LONG + 69
	CURLOPT_TELNETOPTIONS = CURLOPTTYPE_OBJECTPOINT + 70
	CURLOPT_MAXCONNECTS = CURLOPTTYPE_LONG + 71
	CURLOPT_OBSOLETE72 = CURLOPTTYPE_LONG + 72
	CURLOPT_FRESH_CONNECT = CURLOPTTYPE_LONG + 74
	CURLOPT_FORBID_REUSE = CURLOPTTYPE_LONG + 75
	CURLOPT_RANDOM_FILE = CURLOPTTYPE_OBJECTPOINT + 76
	CURLOPT_EGDSOCKET = CURLOPTTYPE_OBJECTPOINT + 77
	CURLOPT_CONNECTTIMEOUT = CURLOPTTYPE_LONG + 78
	CURLOPT_HEADERFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 79
	CURLOPT_HTTPGET = CURLOPTTYPE_LONG + 80
	CURLOPT_SSL_VERIFYHOST = CURLOPTTYPE_LONG + 81
	CURLOPT_COOKIEJAR = CURLOPTTYPE_OBJECTPOINT + 82
	CURLOPT_SSL_CIPHER_LIST = CURLOPTTYPE_OBJECTPOINT + 83
	CURLOPT_HTTP_VERSION = CURLOPTTYPE_LONG + 84
	CURLOPT_FTP_USE_EPSV = CURLOPTTYPE_LONG + 85
	CURLOPT_SSLCERTTYPE = CURLOPTTYPE_OBJECTPOINT + 86
	CURLOPT_SSLKEY = CURLOPTTYPE_OBJECTPOINT + 87
	CURLOPT_SSLKEYTYPE = CURLOPTTYPE_OBJECTPOINT + 88
	CURLOPT_SSLENGINE = CURLOPTTYPE_OBJECTPOINT + 89
	CURLOPT_SSLENGINE_DEFAULT = CURLOPTTYPE_LONG + 90
	CURLOPT_DNS_USE_GLOBAL_CACHE = CURLOPTTYPE_LONG + 91
	CURLOPT_DNS_CACHE_TIMEOUT = CURLOPTTYPE_LONG + 92
	CURLOPT_PREQUOTE = CURLOPTTYPE_OBJECTPOINT + 93
	CURLOPT_DEBUGFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 94
	CURLOPT_DEBUGDATA = CURLOPTTYPE_OBJECTPOINT + 95
	CURLOPT_COOKIESESSION = CURLOPTTYPE_LONG + 96
	CURLOPT_CAPATH = CURLOPTTYPE_OBJECTPOINT + 97
	CURLOPT_BUFFERSIZE = CURLOPTTYPE_LONG + 98
	CURLOPT_NOSIGNAL = CURLOPTTYPE_LONG + 99
	CURLOPT_SHARE = CURLOPTTYPE_OBJECTPOINT + 100
	CURLOPT_PROXYTYPE = CURLOPTTYPE_LONG + 101
	CURLOPT_ACCEPT_ENCODING = CURLOPTTYPE_OBJECTPOINT + 102
	CURLOPT_PRIVATE = CURLOPTTYPE_OBJECTPOINT + 103
	CURLOPT_HTTP200ALIASES = CURLOPTTYPE_OBJECTPOINT + 104
	CURLOPT_UNRESTRICTED_AUTH = CURLOPTTYPE_LONG + 105
	CURLOPT_FTP_USE_EPRT = CURLOPTTYPE_LONG + 106
	CURLOPT_HTTPAUTH = CURLOPTTYPE_LONG + 107
	CURLOPT_SSL_CTX_FUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 108
	CURLOPT_SSL_CTX_DATA = CURLOPTTYPE_OBJECTPOINT + 109
	CURLOPT_FTP_CREATE_MISSING_DIRS = CURLOPTTYPE_LONG + 110
	CURLOPT_PROXYAUTH = CURLOPTTYPE_LONG + 111
	CURLOPT_SERVER_RESPONSE_TIMEOUT = CURLOPTTYPE_LONG + 112
	CURLOPT_IPRESOLVE = CURLOPTTYPE_LONG + 113
	CURLOPT_MAXFILESIZE = CURLOPTTYPE_LONG + 114
	CURLOPT_INFILESIZE_LARGE = CURLOPTTYPE_OFF_T + 115
	CURLOPT_RESUME_FROM_LARGE = CURLOPTTYPE_OFF_T + 116
	CURLOPT_MAXFILESIZE_LARGE = CURLOPTTYPE_OFF_T + 117
	CURLOPT_NETRC_FILE = CURLOPTTYPE_OBJECTPOINT + 118
	CURLOPT_USE_SSL = CURLOPTTYPE_LONG + 119
	CURLOPT_POSTFIELDSIZE_LARGE = CURLOPTTYPE_OFF_T + 120
	CURLOPT_TCP_NODELAY = CURLOPTTYPE_LONG + 121
	CURLOPT_FTPSSLAUTH = CURLOPTTYPE_LONG + 129
	CURLOPT_IOCTLFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 130
	CURLOPT_IOCTLDATA = CURLOPTTYPE_OBJECTPOINT + 131
	CURLOPT_FTP_ACCOUNT = CURLOPTTYPE_OBJECTPOINT + 134
	CURLOPT_COOKIELIST = CURLOPTTYPE_OBJECTPOINT + 135
	CURLOPT_IGNORE_CONTENT_LENGTH = CURLOPTTYPE_LONG + 136
	CURLOPT_FTP_SKIP_PASV_IP = CURLOPTTYPE_LONG + 137
	CURLOPT_FTP_FILEMETHOD = CURLOPTTYPE_LONG + 138
	CURLOPT_LOCALPORT = CURLOPTTYPE_LONG + 139
	CURLOPT_LOCALPORTRANGE = CURLOPTTYPE_LONG + 140
	CURLOPT_CONNECT_ONLY = CURLOPTTYPE_LONG + 141
	CURLOPT_CONV_FROM_NETWORK_FUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 142
	CURLOPT_CONV_TO_NETWORK_FUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 143
	CURLOPT_CONV_FROM_UTF8_FUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 144
	CURLOPT_MAX_SEND_SPEED_LARGE = CURLOPTTYPE_OFF_T + 145
	CURLOPT_MAX_RECV_SPEED_LARGE = CURLOPTTYPE_OFF_T + 146
	CURLOPT_FTP_ALTERNATIVE_TO_USER = CURLOPTTYPE_OBJECTPOINT + 147
	CURLOPT_SOCKOPTFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 148
	CURLOPT_SOCKOPTDATA = CURLOPTTYPE_OBJECTPOINT + 149
	CURLOPT_SSL_SESSIONID_CACHE = CURLOPTTYPE_LONG + 150
	CURLOPT_SSH_AUTH_TYPES = CURLOPTTYPE_LONG + 151
	CURLOPT_SSH_PUBLIC_KEYFILE = CURLOPTTYPE_OBJECTPOINT + 152
	CURLOPT_SSH_PRIVATE_KEYFILE = CURLOPTTYPE_OBJECTPOINT + 153
	CURLOPT_FTP_SSL_CCC = CURLOPTTYPE_LONG + 154
	CURLOPT_TIMEOUT_MS = CURLOPTTYPE_LONG + 155
	CURLOPT_CONNECTTIMEOUT_MS = CURLOPTTYPE_LONG + 156
	CURLOPT_HTTP_TRANSFER_DECODING = CURLOPTTYPE_LONG + 157
	CURLOPT_HTTP_CONTENT_DECODING = CURLOPTTYPE_LONG + 158
	CURLOPT_NEW_FILE_PERMS = CURLOPTTYPE_LONG + 159
	CURLOPT_NEW_DIRECTORY_PERMS = CURLOPTTYPE_LONG + 160
	CURLOPT_POSTREDIR = CURLOPTTYPE_LONG + 161
	CURLOPT_SSH_HOST_PUBLIC_KEY_MD5 = CURLOPTTYPE_OBJECTPOINT + 162
	CURLOPT_OPENSOCKETFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 163
	CURLOPT_OPENSOCKETDATA = CURLOPTTYPE_OBJECTPOINT + 164
	CURLOPT_COPYPOSTFIELDS = CURLOPTTYPE_OBJECTPOINT + 165
	CURLOPT_PROXY_TRANSFER_MODE = CURLOPTTYPE_LONG + 166
	CURLOPT_SEEKFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 167
	CURLOPT_SEEKDATA = CURLOPTTYPE_OBJECTPOINT + 168
	CURLOPT_CRLFILE = CURLOPTTYPE_OBJECTPOINT + 169
	CURLOPT_ISSUERCERT = CURLOPTTYPE_OBJECTPOINT + 170
	CURLOPT_ADDRESS_SCOPE = CURLOPTTYPE_LONG + 171
	CURLOPT_CERTINFO = CURLOPTTYPE_LONG + 172
	CURLOPT_USERNAME = CURLOPTTYPE_OBJECTPOINT + 173
	CURLOPT_PASSWORD = CURLOPTTYPE_OBJECTPOINT + 174
	CURLOPT_PROXYUSERNAME = CURLOPTTYPE_OBJECTPOINT + 175
	CURLOPT_PROXYPASSWORD = CURLOPTTYPE_OBJECTPOINT + 176
	CURLOPT_NOPROXY = CURLOPTTYPE_OBJECTPOINT + 177
	CURLOPT_TFTP_BLKSIZE = CURLOPTTYPE_LONG + 178
	CURLOPT_SOCKS5_GSSAPI_SERVICE = CURLOPTTYPE_OBJECTPOINT + 179
	CURLOPT_SOCKS5_GSSAPI_NEC = CURLOPTTYPE_LONG + 180
	CURLOPT_PROTOCOLS = CURLOPTTYPE_LONG + 181
	CURLOPT_REDIR_PROTOCOLS = CURLOPTTYPE_LONG + 182
	CURLOPT_SSH_KNOWNHOSTS = CURLOPTTYPE_OBJECTPOINT + 183
	CURLOPT_SSH_KEYFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 184
	CURLOPT_SSH_KEYDATA = CURLOPTTYPE_OBJECTPOINT + 185
	CURLOPT_MAIL_FROM = CURLOPTTYPE_OBJECTPOINT + 186
	CURLOPT_MAIL_RCPT = CURLOPTTYPE_OBJECTPOINT + 187
	CURLOPT_FTP_USE_PRET = CURLOPTTYPE_LONG + 188
	CURLOPT_RTSP_REQUEST = CURLOPTTYPE_LONG + 189
	CURLOPT_RTSP_SESSION_ID = CURLOPTTYPE_OBJECTPOINT + 190
	CURLOPT_RTSP_STREAM_URI = CURLOPTTYPE_OBJECTPOINT + 191
	CURLOPT_RTSP_TRANSPORT = CURLOPTTYPE_OBJECTPOINT + 192
	CURLOPT_RTSP_CLIENT_CSEQ = CURLOPTTYPE_LONG + 193
	CURLOPT_RTSP_SERVER_CSEQ = CURLOPTTYPE_LONG + 194
	CURLOPT_INTERLEAVEDATA = CURLOPTTYPE_OBJECTPOINT + 195
	CURLOPT_INTERLEAVEFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 196
	CURLOPT_WILDCARDMATCH = CURLOPTTYPE_LONG + 197
	CURLOPT_CHUNK_BGN_FUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 198
	CURLOPT_CHUNK_END_FUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 199
	CURLOPT_FNMATCH_FUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 200
	CURLOPT_CHUNK_DATA = CURLOPTTYPE_OBJECTPOINT + 201
	CURLOPT_FNMATCH_DATA = CURLOPTTYPE_OBJECTPOINT + 202
	CURLOPT_RESOLVE = CURLOPTTYPE_OBJECTPOINT + 203
	CURLOPT_TLSAUTH_USERNAME = CURLOPTTYPE_OBJECTPOINT + 204
	CURLOPT_TLSAUTH_PASSWORD = CURLOPTTYPE_OBJECTPOINT + 205
	CURLOPT_TLSAUTH_TYPE = CURLOPTTYPE_OBJECTPOINT + 206
	CURLOPT_TRANSFER_ENCODING = CURLOPTTYPE_LONG + 207
	CURLOPT_CLOSESOCKETFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 208
	CURLOPT_CLOSESOCKETDATA = CURLOPTTYPE_OBJECTPOINT + 209
	CURLOPT_GSSAPI_DELEGATION = CURLOPTTYPE_LONG + 210
	CURLOPT_DNS_SERVERS = CURLOPTTYPE_OBJECTPOINT + 211
	CURLOPT_ACCEPTTIMEOUT_MS = CURLOPTTYPE_LONG + 212
	CURLOPT_TCP_KEEPALIVE = CURLOPTTYPE_LONG + 213
	CURLOPT_TCP_KEEPIDLE = CURLOPTTYPE_LONG + 214
	CURLOPT_TCP_KEEPINTVL = CURLOPTTYPE_LONG + 215
	CURLOPT_SSL_OPTIONS = CURLOPTTYPE_LONG + 216
	CURLOPT_MAIL_AUTH = CURLOPTTYPE_OBJECTPOINT + 217
	CURLOPT_SASL_IR = CURLOPTTYPE_LONG + 218
	CURLOPT_XFERINFOFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 219
	CURLOPT_XOAUTH2_BEARER = CURLOPTTYPE_OBJECTPOINT + 220
	CURLOPT_DNS_INTERFACE = CURLOPTTYPE_OBJECTPOINT + 221
	CURLOPT_DNS_LOCAL_IP4 = CURLOPTTYPE_OBJECTPOINT + 222
	CURLOPT_DNS_LOCAL_IP6 = CURLOPTTYPE_OBJECTPOINT + 223
	CURLOPT_LOGIN_OPTIONS = CURLOPTTYPE_OBJECTPOINT + 224
	CURLOPT_SSL_ENABLE_NPN = CURLOPTTYPE_LONG + 225
	CURLOPT_SSL_ENABLE_ALPN = CURLOPTTYPE_LONG + 226
	CURLOPT_EXPECT_100_TIMEOUT_MS = CURLOPTTYPE_LONG + 227
	CURLOPT_PROXYHEADER = CURLOPTTYPE_OBJECTPOINT + 228
	CURLOPT_HEADEROPT = CURLOPTTYPE_LONG + 229
	CURLOPT_PINNEDPUBLICKEY = CURLOPTTYPE_OBJECTPOINT + 230
	CURLOPT_UNIX_SOCKET_PATH = CURLOPTTYPE_OBJECTPOINT + 231
	CURLOPT_SSL_VERIFYSTATUS = CURLOPTTYPE_LONG + 232
	CURLOPT_SSL_FALSESTART = CURLOPTTYPE_LONG + 233
	CURLOPT_PATH_AS_IS = CURLOPTTYPE_LONG + 234
	CURLOPT_PROXY_SERVICE_NAME = CURLOPTTYPE_OBJECTPOINT + 235
	CURLOPT_SERVICE_NAME = CURLOPTTYPE_OBJECTPOINT + 236
	CURLOPT_PIPEWAIT = CURLOPTTYPE_LONG + 237
	CURLOPT_DEFAULT_PROTOCOL = CURLOPTTYPE_OBJECTPOINT + 238
	CURLOPT_STREAM_WEIGHT = CURLOPTTYPE_LONG + 239
	CURLOPT_STREAM_DEPENDS = CURLOPTTYPE_OBJECTPOINT + 240
	CURLOPT_STREAM_DEPENDS_E = CURLOPTTYPE_OBJECTPOINT + 241
	CURLOPT_TFTP_NO_OPTIONS = CURLOPTTYPE_LONG + 242
	CURLOPT_CONNECT_TO = CURLOPTTYPE_OBJECTPOINT + 243
	CURLOPT_TCP_FASTOPEN = CURLOPTTYPE_LONG + 244
	CURLOPT_KEEP_SENDING_ON_ERROR = CURLOPTTYPE_LONG + 245
	CURLOPT_PROXY_CAINFO = CURLOPTTYPE_OBJECTPOINT + 246
	CURLOPT_PROXY_CAPATH = CURLOPTTYPE_OBJECTPOINT + 247
	CURLOPT_PROXY_SSL_VERIFYPEER = CURLOPTTYPE_LONG + 248
	CURLOPT_PROXY_SSL_VERIFYHOST = CURLOPTTYPE_LONG + 249
	CURLOPT_PROXY_SSLVERSION = CURLOPTTYPE_LONG + 250
	CURLOPT_PROXY_TLSAUTH_USERNAME = CURLOPTTYPE_OBJECTPOINT + 251
	CURLOPT_PROXY_TLSAUTH_PASSWORD = CURLOPTTYPE_OBJECTPOINT + 252
	CURLOPT_PROXY_TLSAUTH_TYPE = CURLOPTTYPE_OBJECTPOINT + 253
	CURLOPT_PROXY_SSLCERT = CURLOPTTYPE_OBJECTPOINT + 254
	CURLOPT_PROXY_SSLCERTTYPE = CURLOPTTYPE_OBJECTPOINT + 255
	CURLOPT_PROXY_SSLKEY = CURLOPTTYPE_OBJECTPOINT + 256
	CURLOPT_PROXY_SSLKEYTYPE = CURLOPTTYPE_OBJECTPOINT + 257
	CURLOPT_PROXY_KEYPASSWD = CURLOPTTYPE_OBJECTPOINT + 258
	CURLOPT_PROXY_SSL_CIPHER_LIST = CURLOPTTYPE_OBJECTPOINT + 259
	CURLOPT_PROXY_CRLFILE = CURLOPTTYPE_OBJECTPOINT + 260
	CURLOPT_PROXY_SSL_OPTIONS = CURLOPTTYPE_LONG + 261
	CURLOPT_PRE_PROXY = CURLOPTTYPE_OBJECTPOINT + 262
	CURLOPT_PROXY_PINNEDPUBLICKEY = CURLOPTTYPE_OBJECTPOINT + 263
	CURLOPT_ABSTRACT_UNIX_SOCKET = CURLOPTTYPE_OBJECTPOINT + 264
	CURLOPT_SUPPRESS_CONNECT_HEADERS = CURLOPTTYPE_LONG + 265
	CURLOPT_REQUEST_TARGET = CURLOPTTYPE_OBJECTPOINT + 266
	CURLOPT_SOCKS5_AUTH = CURLOPTTYPE_LONG + 267
	CURLOPT_SSH_COMPRESSION = CURLOPTTYPE_LONG + 268
	CURLOPT_MIMEPOST = CURLOPTTYPE_OBJECTPOINT + 269
	CURLOPT_TIMEVALUE_LARGE = CURLOPTTYPE_OFF_T + 270
	CURLOPT_HAPPY_EYEBALLS_TIMEOUT_MS = CURLOPTTYPE_LONG + 271
	CURLOPT_RESOLVER_START_FUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 272
	CURLOPT_RESOLVER_START_DATA = CURLOPTTYPE_OBJECTPOINT + 273
	CURLOPT_HAPROXYPROTOCOL = CURLOPTTYPE_LONG + 274
	CURLOPT_DNS_SHUFFLE_ADDRESSES = CURLOPTTYPE_LONG + 275
	CURLOPT_TLS13_CIPHERS = CURLOPTTYPE_OBJECTPOINT + 276
	CURLOPT_PROXY_TLS13_CIPHERS = CURLOPTTYPE_OBJECTPOINT + 277
	CURLOPT_DISALLOW_USERNAME_IN_URL = CURLOPTTYPE_LONG + 278
	CURLOPT_DOH_URL = CURLOPTTYPE_OBJECTPOINT + 279
	CURLOPT_UPLOAD_BUFFERSIZE = CURLOPTTYPE_LONG + 280
	CURLOPT_UPKEEP_INTERVAL_MS = CURLOPTTYPE_LONG + 281
	CURLOPT_CURLU = CURLOPTTYPE_OBJECTPOINT + 282
	CURLOPT_TRAILERFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 283
	CURLOPT_TRAILERDATA = CURLOPTTYPE_OBJECTPOINT + 284
	CURLOPT_HTTP09_ALLOWED = CURLOPTTYPE_LONG + 285
	CURLOPT_ALTSVC_CTRL = CURLOPTTYPE_LONG + 286
	CURLOPT_ALTSVC = CURLOPTTYPE_OBJECTPOINT + 287
	CURLOPT_MAXAGE_CONN = CURLOPTTYPE_LONG + 288
	CURLOPT_SASL_AUTHZID = CURLOPTTYPE_OBJECTPOINT + 289
	CURLOPT_MAIL_RCPT_ALLLOWFAILS = CURLOPTTYPE_LONG + 290
	CURLOPT_SSLCERT_BLOB = CURLOPTTYPE_BLOB + 291
	CURLOPT_SSLKEY_BLOB = CURLOPTTYPE_BLOB + 292
	CURLOPT_PROXY_SSLCERT_BLOB = CURLOPTTYPE_BLOB + 293
	CURLOPT_PROXY_SSLKEY_BLOB = CURLOPTTYPE_BLOB + 294
	CURLOPT_ISSUERCERT_BLOB = CURLOPTTYPE_BLOB + 295
	CURLOPT_PROXY_ISSUERCERT = CURLOPTTYPE_OBJECTPOINT + 296
	CURLOPT_PROXY_ISSUERCERT_BLOB = CURLOPTTYPE_BLOB + 297
	CURLOPT_SSL_EC_CURVES = CURLOPTTYPE_OBJECTPOINT + 298
	CURLOPT_HSTS_CTRL = CURLOPTTYPE_LONG + 299
	CURLOPT_HSTS = CURLOPTTYPE_OBJECTPOINT + 300
	CURLOPT_HSTSREADFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 301
	CURLOPT_HSTSREADDATA = CURLOPTTYPE_OBJECTPOINT + 302
	CURLOPT_HSTSWRITEFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 303
	CURLOPT_HSTSWRITEDATA = CURLOPTTYPE_OBJECTPOINT + 304
	CURLOPT_AWS_SIGV4 = CURLOPTTYPE_OBJECTPOINT + 305
	CURLOPT_DOH_SSL_VERIFYPEER = CURLOPTTYPE_LONG + 306
	CURLOPT_DOH_SSL_VERIFYHOST = CURLOPTTYPE_LONG + 307
	CURLOPT_DOH_SSL_VERIFYSTATUS = CURLOPTTYPE_LONG + 308
	CURLOPT_CAINFO_BLOB = CURLOPTTYPE_BLOB + 309
	CURLOPT_PROXY_CAINFO_BLOB = CURLOPTTYPE_BLOB + 310
	CURLOPT_SSH_HOST_PUBLIC_KEY_SHA256 = CURLOPTTYPE_OBJECTPOINT + 311
	CURLOPT_PREREQFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 312
	CURLOPT_PREREQDATA = CURLOPTTYPE_OBJECTPOINT + 313
	CURLOPT_MAXLIFETIME_CONN = CURLOPTTYPE_LONG + 314
	CURLOPT_MIME_OPTIONS = CURLOPTTYPE_LONG + 315
	CURLOPT_SSH_HOSTKEYFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 316
	CURLOPT_SSH_HOSTKEYDATA = CURLOPTTYPE_OBJECTPOINT + 317
	CURLOPT_PROTOCOLS_STR = CURLOPTTYPE_OBJECTPOINT + 318
	CURLOPT_REDIR_PROTOCOLS_STR = CURLOPTTYPE_OBJECTPOINT + 319
	CURLOPT_LASTENTRY
end enum

const CURLOPT_ENCODING = CURLOPT_ACCEPT_ENCODING
const CURLOPT_CLOSEPOLICY = CURLOPT_OBSOLETE72
const CURLOPT_WRITEINFO = CURLOPT_OBSOLETE40
const CURLOPT_WRITEHEADER = CURLOPT_HEADERDATA
const CURLOPT_INFILE = CURLOPT_READDATA
const CURLOPT_FILE = CURLOPT_WRITEDATA
const CURLOPT_PROGRESSDATA = CURLOPT_XFERINFODATA
const CURLOPT_POST301 = CURLOPT_POSTREDIR
const CURLOPT_SSLKEYPASSWD = CURLOPT_KEYPASSWD
const CURLOPT_FTPAPPEND = CURLOPT_APPEND
const CURLOPT_FTPLISTONLY = CURLOPT_DIRLISTONLY
const CURLOPT_FTP_SSL = CURLOPT_USE_SSL
const CURLOPT_SSLCERTPASSWD = CURLOPT_KEYPASSWD
const CURLOPT_KRB4LEVEL = CURLOPT_KRBLEVEL
const CURLOPT_FTP_RESPONSE_TIMEOUT = CURLOPT_SERVER_RESPONSE_TIMEOUT
const CURL_IPRESOLVE_WHATEVER = 0
const CURL_IPRESOLVE_V4 = 1
const CURL_IPRESOLVE_V6 = 2
const CURLOPT_RTSPHEADER = CURLOPT_HTTPHEADER

enum
	CURL_HTTP_VERSION_NONE
	CURL_HTTP_VERSION_1_0
	CURL_HTTP_VERSION_1_1
	CURL_HTTP_VERSION_2_0
	CURL_HTTP_VERSION_2TLS
	CURL_HTTP_VERSION_2_PRIOR_KNOWLEDGE
	CURL_HTTP_VERSION_3 = 30
	CURL_HTTP_VERSION_LAST
end enum

const CURL_HTTP_VERSION_2 = CURL_HTTP_VERSION_2_0

enum
	CURL_RTSPREQ_NONE
	CURL_RTSPREQ_OPTIONS
	CURL_RTSPREQ_DESCRIBE
	CURL_RTSPREQ_ANNOUNCE
	CURL_RTSPREQ_SETUP
	CURL_RTSPREQ_PLAY
	CURL_RTSPREQ_PAUSE
	CURL_RTSPREQ_TEARDOWN
	CURL_RTSPREQ_GET_PARAMETER
	CURL_RTSPREQ_SET_PARAMETER
	CURL_RTSPREQ_RECORD
	CURL_RTSPREQ_RECEIVE
	CURL_RTSPREQ_LAST
end enum

type CURL_NETRC_OPTION as long
enum
	CURL_NETRC_IGNORED
	CURL_NETRC_OPTIONAL
	CURL_NETRC_REQUIRED
	CURL_NETRC_LAST
end enum

enum
	CURL_SSLVERSION_DEFAULT
	CURL_SSLVERSION_TLSv1
	CURL_SSLVERSION_SSLv2
	CURL_SSLVERSION_SSLv3
	CURL_SSLVERSION_TLSv1_0
	CURL_SSLVERSION_TLSv1_1
	CURL_SSLVERSION_TLSv1_2
	CURL_SSLVERSION_TLSv1_3
	CURL_SSLVERSION_LAST
end enum

enum
	CURL_SSLVERSION_MAX_NONE = 0
	CURL_SSLVERSION_MAX_DEFAULT = CURL_SSLVERSION_TLSv1 shl 16
	CURL_SSLVERSION_MAX_TLSv1_0 = CURL_SSLVERSION_TLSv1_0 shl 16
	CURL_SSLVERSION_MAX_TLSv1_1 = CURL_SSLVERSION_TLSv1_1 shl 16
	CURL_SSLVERSION_MAX_TLSv1_2 = CURL_SSLVERSION_TLSv1_2 shl 16
	CURL_SSLVERSION_MAX_TLSv1_3 = CURL_SSLVERSION_TLSv1_3 shl 16
	CURL_SSLVERSION_MAX_LAST = CURL_SSLVERSION_LAST shl 16
end enum

type CURL_TLSAUTH as long
enum
	CURL_TLSAUTH_NONE
	CURL_TLSAUTH_SRP
	CURL_TLSAUTH_LAST
end enum

const CURL_REDIR_GET_ALL = 0
const CURL_REDIR_POST_301 = 1
const CURL_REDIR_POST_302 = 2
const CURL_REDIR_POST_303 = 4
const CURL_REDIR_POST_ALL = (CURL_REDIR_POST_301 or CURL_REDIR_POST_302) or CURL_REDIR_POST_303

type curl_TimeCond as long
enum
	CURL_TIMECOND_NONE
	CURL_TIMECOND_IFMODSINCE
	CURL_TIMECOND_IFUNMODSINCE
	CURL_TIMECOND_LASTMOD
	CURL_TIMECOND_LAST
end enum

const CURL_ZERO_TERMINATED = cuint(-1)
declare function curl_strequal(byval s1 as const zstring ptr, byval s2 as const zstring ptr) as long
declare function curl_strnequal(byval s1 as const zstring ptr, byval s2 as const zstring ptr, byval n as uinteger) as long
const CURLMIMEOPT_FORMESCAPE = 1 shl 0
type curl_mime as curl_mime_
declare function curl_mime_init(byval easy as CURL ptr) as curl_mime ptr
declare sub curl_mime_free(byval mime as curl_mime ptr)
type curl_mimepart as curl_mimepart_
declare function curl_mime_addpart(byval mime as curl_mime ptr) as curl_mimepart ptr
declare function curl_mime_name(byval part as curl_mimepart ptr, byval name as const zstring ptr) as CURLcode
declare function curl_mime_filename(byval part as curl_mimepart ptr, byval filename as const zstring ptr) as CURLcode
declare function curl_mime_type(byval part as curl_mimepart ptr, byval mimetype as const zstring ptr) as CURLcode
declare function curl_mime_encoder(byval part as curl_mimepart ptr, byval encoding as const zstring ptr) as CURLcode
declare function curl_mime_data(byval part as curl_mimepart ptr, byval data as const zstring ptr, byval datasize as uinteger) as CURLcode
declare function curl_mime_filedata(byval part as curl_mimepart ptr, byval filename as const zstring ptr) as CURLcode
declare function curl_mime_data_cb(byval part as curl_mimepart ptr, byval datasize as curl_off_t, byval readfunc as curl_read_callback, byval seekfunc as curl_seek_callback, byval freefunc as curl_free_callback, byval arg as any ptr) as CURLcode
declare function curl_mime_subparts(byval part as curl_mimepart ptr, byval subparts as curl_mime ptr) as CURLcode
declare function curl_mime_headers(byval part as curl_mimepart ptr, byval headers as curl_slist ptr, byval take_ownership as long) as CURLcode

type CURLformoption as long
enum
	CURLFORM_NOTHING
	CURLFORM_COPYNAME
	CURLFORM_PTRNAME
	CURLFORM_NAMELENGTH
	CURLFORM_COPYCONTENTS
	CURLFORM_PTRCONTENTS
	CURLFORM_CONTENTSLENGTH
	CURLFORM_FILECONTENT
	CURLFORM_ARRAY
	CURLFORM_OBSOLETE
	CURLFORM_FILE
	CURLFORM_BUFFER
	CURLFORM_BUFFERPTR
	CURLFORM_BUFFERLENGTH
	CURLFORM_CONTENTTYPE
	CURLFORM_CONTENTHEADER
	CURLFORM_FILENAME
	CURLFORM_END
	CURLFORM_OBSOLETE2
	CURLFORM_STREAM
	CURLFORM_CONTENTLEN
	CURLFORM_LASTENTRY
end enum

type curl_forms
	option as CURLformoption
	value as const zstring ptr
end type

type CURLFORMcode as long
enum
	CURL_FORMADD_OK
	CURL_FORMADD_MEMORY
	CURL_FORMADD_OPTION_TWICE
	CURL_FORMADD_NULL
	CURL_FORMADD_UNKNOWN_OPTION
	CURL_FORMADD_INCOMPLETE
	CURL_FORMADD_ILLEGAL_ARRAY
	CURL_FORMADD_DISABLED
	CURL_FORMADD_LAST
end enum

declare function curl_formadd(byval httppost as curl_httppost ptr ptr, byval last_post as curl_httppost ptr ptr, ...) as CURLFORMcode
type curl_formget_callback as function(byval arg as any ptr, byval buf as const zstring ptr, byval len as uinteger) as uinteger
declare function curl_formget(byval form as curl_httppost ptr, byval arg as any ptr, byval append as curl_formget_callback) as long
declare sub curl_formfree(byval form as curl_httppost ptr)
declare function curl_getenv(byval variable as const zstring ptr) as zstring ptr
declare function curl_version() as zstring ptr
declare function curl_easy_escape(byval handle as CURL ptr, byval string as const zstring ptr, byval length as long) as zstring ptr
declare function curl_escape(byval string as const zstring ptr, byval length as long) as zstring ptr
declare function curl_easy_unescape(byval handle as CURL ptr, byval string as const zstring ptr, byval length as long, byval outlength as long ptr) as zstring ptr
declare function curl_unescape(byval string as const zstring ptr, byval length as long) as zstring ptr
declare sub curl_free(byval p as any ptr)
declare function curl_global_init(byval flags as clong) as CURLcode
declare function curl_global_init_mem(byval flags as clong, byval m as curl_malloc_callback, byval f as curl_free_callback, byval r as curl_realloc_callback, byval s as curl_strdup_callback, byval c as curl_calloc_callback) as CURLcode
declare sub curl_global_cleanup()

type curl_slist_
	data as zstring ptr
	next as curl_slist ptr
end type

type curl_ssl_backend
	id as curl_sslbackend
	name as const zstring ptr
end type

type CURLsslset as long
enum
	CURLSSLSET_OK = 0
	CURLSSLSET_UNKNOWN_BACKEND
	CURLSSLSET_TOO_LATE
	CURLSSLSET_NO_BACKENDS
end enum

declare function curl_global_sslset(byval id as curl_sslbackend, byval name as const zstring ptr, byval avail as const curl_ssl_backend ptr ptr ptr) as CURLsslset
declare function curl_slist_append(byval as curl_slist ptr, byval as const zstring ptr) as curl_slist ptr
declare sub curl_slist_free_all(byval as curl_slist ptr)
declare function curl_getdate(byval p as const zstring ptr, byval unused as const time_t ptr) as time_t

type curl_certinfo
	num_of_certs as long
	certinfo as curl_slist ptr ptr
end type

type curl_tlssessioninfo
	backend as curl_sslbackend
	internals as any ptr
end type

const CURLINFO_STRING = &h100000
const CURLINFO_LONG = &h200000
const CURLINFO_DOUBLE = &h300000
const CURLINFO_SLIST = &h400000
const CURLINFO_PTR = &h400000
const CURLINFO_SOCKET = &h500000
const CURLINFO_OFF_T = &h600000
const CURLINFO_MASK = &h0fffff
const CURLINFO_TYPEMASK = &hf00000

type CURLINFO as long
enum
	CURLINFO_NONE
	CURLINFO_EFFECTIVE_URL = CURLINFO_STRING + 1
	CURLINFO_RESPONSE_CODE = CURLINFO_LONG + 2
	CURLINFO_TOTAL_TIME = CURLINFO_DOUBLE + 3
	CURLINFO_NAMELOOKUP_TIME = CURLINFO_DOUBLE + 4
	CURLINFO_CONNECT_TIME = CURLINFO_DOUBLE + 5
	CURLINFO_PRETRANSFER_TIME = CURLINFO_DOUBLE + 6
	CURLINFO_SIZE_UPLOAD = CURLINFO_DOUBLE + 7
	CURLINFO_SIZE_UPLOAD_T = CURLINFO_OFF_T + 7
	CURLINFO_SIZE_DOWNLOAD = CURLINFO_DOUBLE + 8
	CURLINFO_SIZE_DOWNLOAD_T = CURLINFO_OFF_T + 8
	CURLINFO_SPEED_DOWNLOAD = CURLINFO_DOUBLE + 9
	CURLINFO_SPEED_DOWNLOAD_T = CURLINFO_OFF_T + 9
	CURLINFO_SPEED_UPLOAD = CURLINFO_DOUBLE + 10
	CURLINFO_SPEED_UPLOAD_T = CURLINFO_OFF_T + 10
	CURLINFO_HEADER_SIZE = CURLINFO_LONG + 11
	CURLINFO_REQUEST_SIZE = CURLINFO_LONG + 12
	CURLINFO_SSL_VERIFYRESULT = CURLINFO_LONG + 13
	CURLINFO_FILETIME = CURLINFO_LONG + 14
	CURLINFO_FILETIME_T = CURLINFO_OFF_T + 14
	CURLINFO_CONTENT_LENGTH_DOWNLOAD = CURLINFO_DOUBLE + 15
	CURLINFO_CONTENT_LENGTH_DOWNLOAD_T = CURLINFO_OFF_T + 15
	CURLINFO_CONTENT_LENGTH_UPLOAD = CURLINFO_DOUBLE + 16
	CURLINFO_CONTENT_LENGTH_UPLOAD_T = CURLINFO_OFF_T + 16
	CURLINFO_STARTTRANSFER_TIME = CURLINFO_DOUBLE + 17
	CURLINFO_CONTENT_TYPE = CURLINFO_STRING + 18
	CURLINFO_REDIRECT_TIME = CURLINFO_DOUBLE + 19
	CURLINFO_REDIRECT_COUNT = CURLINFO_LONG + 20
	CURLINFO_PRIVATE = CURLINFO_STRING + 21
	CURLINFO_HTTP_CONNECTCODE = CURLINFO_LONG + 22
	CURLINFO_HTTPAUTH_AVAIL = CURLINFO_LONG + 23
	CURLINFO_PROXYAUTH_AVAIL = CURLINFO_LONG + 24
	CURLINFO_OS_ERRNO = CURLINFO_LONG + 25
	CURLINFO_NUM_CONNECTS = CURLINFO_LONG + 26
	CURLINFO_SSL_ENGINES = CURLINFO_SLIST + 27
	CURLINFO_COOKIELIST = CURLINFO_SLIST + 28
	CURLINFO_LASTSOCKET = CURLINFO_LONG + 29
	CURLINFO_FTP_ENTRY_PATH = CURLINFO_STRING + 30
	CURLINFO_REDIRECT_URL = CURLINFO_STRING + 31
	CURLINFO_PRIMARY_IP = CURLINFO_STRING + 32
	CURLINFO_APPCONNECT_TIME = CURLINFO_DOUBLE + 33
	CURLINFO_CERTINFO = CURLINFO_PTR + 34
	CURLINFO_CONDITION_UNMET = CURLINFO_LONG + 35
	CURLINFO_RTSP_SESSION_ID = CURLINFO_STRING + 36
	CURLINFO_RTSP_CLIENT_CSEQ = CURLINFO_LONG + 37
	CURLINFO_RTSP_SERVER_CSEQ = CURLINFO_LONG + 38
	CURLINFO_RTSP_CSEQ_RECV = CURLINFO_LONG + 39
	CURLINFO_PRIMARY_PORT = CURLINFO_LONG + 40
	CURLINFO_LOCAL_IP = CURLINFO_STRING + 41
	CURLINFO_LOCAL_PORT = CURLINFO_LONG + 42
	CURLINFO_TLS_SESSION = CURLINFO_PTR + 43
	CURLINFO_ACTIVESOCKET = CURLINFO_SOCKET + 44
	CURLINFO_TLS_SSL_PTR = CURLINFO_PTR + 45
	CURLINFO_HTTP_VERSION = CURLINFO_LONG + 46
	CURLINFO_PROXY_SSL_VERIFYRESULT = CURLINFO_LONG + 47
	CURLINFO_PROTOCOL = CURLINFO_LONG + 48
	CURLINFO_SCHEME = CURLINFO_STRING + 49
	CURLINFO_TOTAL_TIME_T = CURLINFO_OFF_T + 50
	CURLINFO_NAMELOOKUP_TIME_T = CURLINFO_OFF_T + 51
	CURLINFO_CONNECT_TIME_T = CURLINFO_OFF_T + 52
	CURLINFO_PRETRANSFER_TIME_T = CURLINFO_OFF_T + 53
	CURLINFO_STARTTRANSFER_TIME_T = CURLINFO_OFF_T + 54
	CURLINFO_REDIRECT_TIME_T = CURLINFO_OFF_T + 55
	CURLINFO_APPCONNECT_TIME_T = CURLINFO_OFF_T + 56
	CURLINFO_RETRY_AFTER = CURLINFO_OFF_T + 57
	CURLINFO_EFFECTIVE_METHOD = CURLINFO_STRING + 58
	CURLINFO_PROXY_ERROR = CURLINFO_LONG + 59
	CURLINFO_REFERER = CURLINFO_STRING + 60
	CURLINFO_CAINFO = CURLINFO_STRING + 61
	CURLINFO_CAPATH = CURLINFO_STRING + 62
	CURLINFO_LASTONE = 62
end enum

const CURLINFO_HTTP_CODE = CURLINFO_RESPONSE_CODE

type curl_closepolicy as long
enum
	CURLCLOSEPOLICY_NONE
	CURLCLOSEPOLICY_OLDEST
	CURLCLOSEPOLICY_LEAST_RECENTLY_USED
	CURLCLOSEPOLICY_LEAST_TRAFFIC
	CURLCLOSEPOLICY_SLOWEST
	CURLCLOSEPOLICY_CALLBACK
	CURLCLOSEPOLICY_LAST
end enum

const CURL_GLOBAL_SSL = 1 shl 0
const CURL_GLOBAL_WIN32 = 1 shl 1
const CURL_GLOBAL_ALL = CURL_GLOBAL_SSL or CURL_GLOBAL_WIN32
const CURL_GLOBAL_NOTHING = 0
const CURL_GLOBAL_DEFAULT = CURL_GLOBAL_ALL
const CURL_GLOBAL_ACK_EINTR = 1 shl 2

type curl_lock_data as long
enum
	CURL_LOCK_DATA_NONE = 0
	CURL_LOCK_DATA_SHARE
	CURL_LOCK_DATA_COOKIE
	CURL_LOCK_DATA_DNS
	CURL_LOCK_DATA_SSL_SESSION
	CURL_LOCK_DATA_CONNECT
	CURL_LOCK_DATA_PSL
	CURL_LOCK_DATA_LAST
end enum

type curl_lock_access as long
enum
	CURL_LOCK_ACCESS_NONE = 0
	CURL_LOCK_ACCESS_SHARED = 1
	CURL_LOCK_ACCESS_SINGLE = 2
	CURL_LOCK_ACCESS_LAST
end enum

type curl_lock_function as sub(byval handle as CURL ptr, byval data as curl_lock_data, byval locktype as curl_lock_access, byval userptr as any ptr)
type curl_unlock_function as sub(byval handle as CURL ptr, byval data as curl_lock_data, byval userptr as any ptr)

type CURLSHcode as long
enum
	CURLSHE_OK
	CURLSHE_BAD_OPTION
	CURLSHE_IN_USE
	CURLSHE_INVALID
	CURLSHE_NOMEM
	CURLSHE_NOT_BUILT_IN
	CURLSHE_LAST
end enum

type CURLSHoption as long
enum
	CURLSHOPT_NONE
	CURLSHOPT_SHARE
	CURLSHOPT_UNSHARE
	CURLSHOPT_LOCKFUNC
	CURLSHOPT_UNLOCKFUNC
	CURLSHOPT_USERDATA
	CURLSHOPT_LAST
end enum

declare function curl_share_init() as CURLSH ptr
declare function curl_share_setopt(byval as CURLSH ptr, byval option as CURLSHoption, ...) as CURLSHcode
declare function curl_share_cleanup(byval as CURLSH ptr) as CURLSHcode

type CURLversion as long
enum
	CURLVERSION_FIRST
	CURLVERSION_SECOND
	CURLVERSION_THIRD
	CURLVERSION_FOURTH
	CURLVERSION_FIFTH
	CURLVERSION_SIXTH
	CURLVERSION_SEVENTH
	CURLVERSION_EIGHTH
	CURLVERSION_NINTH
	CURLVERSION_TENTH
	CURLVERSION_LAST
end enum

const CURLVERSION_NOW = CURLVERSION_TENTH

type curl_version_info_data
	age as CURLversion
	version as const zstring ptr
	version_num as ulong
	host as const zstring ptr
	features as long
	ssl_version as const zstring ptr
	ssl_version_num as clong
	libz_version as const zstring ptr
	protocols as const zstring const ptr ptr
	ares as const zstring ptr
	ares_num as long
	libidn as const zstring ptr
	iconv_ver_num as long
	libssh_version as const zstring ptr
	brotli_ver_num as ulong
	brotli_version as const zstring ptr
	nghttp2_ver_num as ulong
	nghttp2_version as const zstring ptr
	quic_version as const zstring ptr
	cainfo as const zstring ptr
	capath as const zstring ptr
	zstd_ver_num as ulong
	zstd_version as const zstring ptr
	hyper_version as const zstring ptr
	gsasl_version as const zstring ptr
end type

const CURL_VERSION_IPV6 = 1 shl 0
const CURL_VERSION_KERBEROS4 = 1 shl 1
const CURL_VERSION_SSL = 1 shl 2
const CURL_VERSION_LIBZ = 1 shl 3
const CURL_VERSION_NTLM = 1 shl 4
const CURL_VERSION_GSSNEGOTIATE = 1 shl 5
const CURL_VERSION_DEBUG = 1 shl 6
const CURL_VERSION_ASYNCHDNS = 1 shl 7
const CURL_VERSION_SPNEGO = 1 shl 8
const CURL_VERSION_LARGEFILE = 1 shl 9
const CURL_VERSION_IDN = 1 shl 10
const CURL_VERSION_SSPI = 1 shl 11
const CURL_VERSION_CONV = 1 shl 12
const CURL_VERSION_CURLDEBUG = 1 shl 13
const CURL_VERSION_TLSAUTH_SRP = 1 shl 14
const CURL_VERSION_NTLM_WB = 1 shl 15
const CURL_VERSION_HTTP2 = 1 shl 16
const CURL_VERSION_GSSAPI = 1 shl 17
const CURL_VERSION_KERBEROS5 = 1 shl 18
const CURL_VERSION_UNIX_SOCKETS = 1 shl 19
const CURL_VERSION_PSL = 1 shl 20
const CURL_VERSION_HTTPS_PROXY = 1 shl 21
const CURL_VERSION_MULTI_SSL = 1 shl 22
const CURL_VERSION_BROTLI = 1 shl 23
const CURL_VERSION_ALTSVC = 1 shl 24
const CURL_VERSION_HTTP3 = 1 shl 25
const CURL_VERSION_ZSTD = 1 shl 26
const CURL_VERSION_UNICODE = 1 shl 27
const CURL_VERSION_HSTS = 1 shl 28
const CURL_VERSION_GSASL = 1 shl 29
const CURL_VERSION_THREADSAFE = 1 shl 30

declare function curl_version_info(byval as CURLversion) as curl_version_info_data ptr
declare function curl_easy_strerror(byval as CURLcode) as const zstring ptr
declare function curl_share_strerror(byval as CURLSHcode) as const zstring ptr
declare function curl_easy_pause(byval handle as CURL ptr, byval bitmask as long) as CURLcode

const CURLPAUSE_RECV = 1 shl 0
const CURLPAUSE_RECV_CONT = 0
const CURLPAUSE_SEND = 1 shl 2
const CURLPAUSE_SEND_CONT = 0
const CURLPAUSE_ALL = CURLPAUSE_RECV or CURLPAUSE_SEND
const CURLPAUSE_CONT = CURLPAUSE_RECV_CONT or CURLPAUSE_SEND_CONT
#define CURLINC_EASY_H
const CURL_BLOB_COPY = 1
const CURL_BLOB_NOCOPY = 0

type curl_blob
	data as any ptr
	len as uinteger
	flags as ulong
end type

declare function curl_easy_init() as CURL ptr
declare function curl_easy_setopt(byval curl as CURL ptr, byval option as CURLoption, ...) as CURLcode
declare function curl_easy_perform(byval curl as CURL ptr) as CURLcode
declare sub curl_easy_cleanup(byval curl as CURL ptr)
declare function curl_easy_getinfo(byval curl as CURL ptr, byval info as CURLINFO, ...) as CURLcode
declare function curl_easy_duphandle(byval curl as CURL ptr) as CURL ptr
declare sub curl_easy_reset(byval curl as CURL ptr)
declare function curl_easy_recv(byval curl as CURL ptr, byval buffer as any ptr, byval buflen as uinteger, byval n as uinteger ptr) as CURLcode
declare function curl_easy_send(byval curl as CURL ptr, byval buffer as const any ptr, byval buflen as uinteger, byval n as uinteger ptr) as CURLcode
declare function curl_easy_upkeep(byval curl as CURL ptr) as CURLcode
#define CURLINC_MULTI_H
type CURLM as any

type CURLMcode as long
enum
	CURLM_CALL_MULTI_PERFORM = -1
	CURLM_OK
	CURLM_BAD_HANDLE
	CURLM_BAD_EASY_HANDLE
	CURLM_OUT_OF_MEMORY
	CURLM_INTERNAL_ERROR
	CURLM_BAD_SOCKET
	CURLM_UNKNOWN_OPTION
	CURLM_ADDED_ALREADY
	CURLM_RECURSIVE_API_CALL
	CURLM_WAKEUP_FAILURE
	CURLM_BAD_FUNCTION_ARGUMENT
	CURLM_ABORTED_BY_CALLBACK
	CURLM_UNRECOVERABLE_POLL
	CURLM_LAST
end enum

const CURLM_CALL_MULTI_SOCKET = CURLM_CALL_MULTI_PERFORM
const CURLPIPE_NOTHING = cast(clong, 0)
const CURLPIPE_HTTP1 = cast(clong, 1)
const CURLPIPE_MULTIPLEX = cast(clong, 2)

type CURLMSG_ as long
enum
	CURLMSG_NONE
	CURLMSG_DONE
	CURLMSG_LAST
end enum

union CURLMsg_data
	whatever as any ptr
	result as CURLcode
end union

type CURLMsg
	msg as CURLMSG_
	easy_handle as CURL ptr
	data as CURLMsg_data
end type

const CURL_WAIT_POLLIN = &h0001
const CURL_WAIT_POLLPRI = &h0002
const CURL_WAIT_POLLOUT = &h0004

type curl_waitfd
	fd as curl_socket_t
	events as short
	revents as short
end type

declare function curl_multi_init() as CURLM ptr
declare function curl_multi_add_handle(byval multi_handle as CURLM ptr, byval curl_handle as CURL ptr) as CURLMcode
declare function curl_multi_remove_handle(byval multi_handle as CURLM ptr, byval curl_handle as CURL ptr) as CURLMcode
declare function curl_multi_fdset(byval multi_handle as CURLM ptr, byval read_fd_set as fd_set ptr, byval write_fd_set as fd_set ptr, byval exc_fd_set as fd_set ptr, byval max_fd as long ptr) as CURLMcode
declare function curl_multi_wait(byval multi_handle as CURLM ptr, byval extra_fds as curl_waitfd ptr, byval extra_nfds as ulong, byval timeout_ms as long, byval ret as long ptr) as CURLMcode
declare function curl_multi_poll(byval multi_handle as CURLM ptr, byval extra_fds as curl_waitfd ptr, byval extra_nfds as ulong, byval timeout_ms as long, byval ret as long ptr) as CURLMcode
declare function curl_multi_wakeup(byval multi_handle as CURLM ptr) as CURLMcode
declare function curl_multi_perform(byval multi_handle as CURLM ptr, byval running_handles as long ptr) as CURLMcode
declare function curl_multi_cleanup(byval multi_handle as CURLM ptr) as CURLMcode
declare function curl_multi_info_read(byval multi_handle as CURLM ptr, byval msgs_in_queue as long ptr) as CURLMsg ptr
declare function curl_multi_strerror(byval as CURLMcode) as const zstring ptr

const CURL_POLL_NONE = 0
const CURL_POLL_IN = 1
const CURL_POLL_OUT = 2
const CURL_POLL_INOUT = 3
const CURL_POLL_REMOVE = 4

#ifdef __FB_WIN32__
	#define CURL_SOCKET_TIMEOUT CURL_SOCKET_BAD
#else
	const CURL_SOCKET_TIMEOUT = CURL_SOCKET_BAD
#endif

const CURL_CSELECT_IN = &h01
const CURL_CSELECT_OUT = &h02
const CURL_CSELECT_ERR = &h04
type curl_socket_callback as function(byval easy as CURL ptr, byval s as curl_socket_t, byval what as long, byval userp as any ptr, byval socketp as any ptr) as long
type curl_multi_timer_callback as function(byval multi as CURLM ptr, byval timeout_ms as clong, byval userp as any ptr) as long

declare function curl_multi_socket_ alias "curl_multi_socket"(byval multi_handle as CURLM ptr, byval s as curl_socket_t, byval running_handles as long ptr) as CURLMcode
declare function curl_multi_socket_action(byval multi_handle as CURLM ptr, byval s as curl_socket_t, byval ev_bitmask as long, byval running_handles as long ptr) as CURLMcode
declare function curl_multi_socket_all(byval multi_handle as CURLM ptr, byval running_handles as long ptr) as CURLMcode
#define curl_multi_socket(x, y, z) curl_multi_socket_action(x, y, 0, z)
declare function curl_multi_timeout(byval multi_handle as CURLM ptr, byval milliseconds as clong ptr) as CURLMcode

type CURLMoption as long
enum
	CURLMOPT_SOCKETFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 1
	CURLMOPT_SOCKETDATA = CURLOPTTYPE_OBJECTPOINT + 2
	CURLMOPT_PIPELINING = CURLOPTTYPE_LONG + 3
	CURLMOPT_TIMERFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 4
	CURLMOPT_TIMERDATA = CURLOPTTYPE_OBJECTPOINT + 5
	CURLMOPT_MAXCONNECTS = CURLOPTTYPE_LONG + 6
	CURLMOPT_MAX_HOST_CONNECTIONS = CURLOPTTYPE_LONG + 7
	CURLMOPT_MAX_PIPELINE_LENGTH = CURLOPTTYPE_LONG + 8
	CURLMOPT_CONTENT_LENGTH_PENALTY_SIZE = CURLOPTTYPE_OFF_T + 9
	CURLMOPT_CHUNK_LENGTH_PENALTY_SIZE = CURLOPTTYPE_OFF_T + 10
	CURLMOPT_PIPELINING_SITE_BL = CURLOPTTYPE_OBJECTPOINT + 11
	CURLMOPT_PIPELINING_SERVER_BL = CURLOPTTYPE_OBJECTPOINT + 12
	CURLMOPT_MAX_TOTAL_CONNECTIONS = CURLOPTTYPE_LONG + 13
	CURLMOPT_PUSHFUNCTION = CURLOPTTYPE_FUNCTIONPOINT + 14
	CURLMOPT_PUSHDATA = CURLOPTTYPE_OBJECTPOINT + 15
	CURLMOPT_MAX_CONCURRENT_STREAMS = CURLOPTTYPE_LONG + 16
	CURLMOPT_LASTENTRY
end enum

declare function curl_multi_setopt(byval multi_handle as CURLM ptr, byval option as CURLMoption, ...) as CURLMcode
declare function curl_multi_assign(byval multi_handle as CURLM ptr, byval sockfd as curl_socket_t, byval sockp as any ptr) as CURLMcode
const CURL_PUSH_OK = 0
const CURL_PUSH_DENY = 1
const CURL_PUSH_ERROROUT = 2
type curl_pushheaders as curl_pushheaders_
declare function curl_pushheader_bynum(byval h as curl_pushheaders ptr, byval num as uinteger) as zstring ptr
declare function curl_pushheader_byname(byval h as curl_pushheaders ptr, byval name as const zstring ptr) as zstring ptr
type curl_push_callback as function(byval parent as CURL ptr, byval easy as CURL ptr, byval num_headers as uinteger, byval headers as curl_pushheaders ptr, byval userp as any ptr) as long
#define CURLINC_URLAPI_H

type CURLUcode as long
enum
	CURLUE_OK
	CURLUE_BAD_HANDLE
	CURLUE_BAD_PARTPOINTER
	CURLUE_MALFORMED_INPUT
	CURLUE_BAD_PORT_NUMBER
	CURLUE_UNSUPPORTED_SCHEME
	CURLUE_URLDECODE
	CURLUE_OUT_OF_MEMORY
	CURLUE_USER_NOT_ALLOWED
	CURLUE_UNKNOWN_PART
	CURLUE_NO_SCHEME
	CURLUE_NO_USER
	CURLUE_NO_PASSWORD
	CURLUE_NO_OPTIONS
	CURLUE_NO_HOST
	CURLUE_NO_PORT
	CURLUE_NO_QUERY
	CURLUE_NO_FRAGMENT
	CURLUE_NO_ZONEID
	CURLUE_BAD_FILE_URL
	CURLUE_BAD_FRAGMENT
	CURLUE_BAD_HOSTNAME
	CURLUE_BAD_IPV6
	CURLUE_BAD_LOGIN
	CURLUE_BAD_PASSWORD
	CURLUE_BAD_PATH
	CURLUE_BAD_QUERY
	CURLUE_BAD_SCHEME
	CURLUE_BAD_SLASHES
	CURLUE_BAD_USER
	CURLUE_LAST
end enum

type CURLUPart as long
enum
	CURLUPART_URL
	CURLUPART_SCHEME
	CURLUPART_USER
	CURLUPART_PASSWORD
	CURLUPART_OPTIONS
	CURLUPART_HOST
	CURLUPART_PORT
	CURLUPART_PATH
	CURLUPART_QUERY
	CURLUPART_FRAGMENT
	CURLUPART_ZONEID
end enum

const CURLU_DEFAULT_PORT = 1 shl 0
const CURLU_NO_DEFAULT_PORT = 1 shl 1
const CURLU_DEFAULT_SCHEME = 1 shl 2
const CURLU_NON_SUPPORT_SCHEME = 1 shl 3
const CURLU_PATH_AS_IS = 1 shl 4
const CURLU_DISALLOW_USER = 1 shl 5
const CURLU_URLDECODE = 1 shl 6
const CURLU_URLENCODE = 1 shl 7
const CURLU_APPENDQUERY = 1 shl 8
const CURLU_GUESS_SCHEME = 1 shl 9
const CURLU_NO_AUTHORITY = 1 shl 10
const CURLU_ALLOW_SPACE = 1 shl 11
type CURLU as Curl_URL

declare function curl_url() as CURLU ptr
declare sub curl_url_cleanup(byval handle as CURLU ptr)
declare function curl_url_dup(byval in as CURLU ptr) as CURLU ptr
declare function curl_url_get(byval handle as CURLU ptr, byval what as CURLUPart, byval part as zstring ptr ptr, byval flags as ulong) as CURLUcode
declare function curl_url_set(byval handle as CURLU ptr, byval what as CURLUPart, byval part as const zstring ptr, byval flags as ulong) as CURLUcode
declare function curl_url_strerror(byval as CURLUcode) as const zstring ptr
#define CURLINC_OPTIONS_H

type curl_easytype as long
enum
	CURLOT_LONG
	CURLOT_VALUES
	CURLOT_OFF_T
	CURLOT_OBJECT
	CURLOT_STRING
	CURLOT_SLIST
	CURLOT_CBPTR
	CURLOT_BLOB
	CURLOT_FUNCTION
end enum

const CURLOT_FLAG_ALIAS = 1 shl 0

type curl_easyoption
	name as const zstring ptr
	id as CURLoption
	as curl_easytype type
	flags as ulong
end type

declare function curl_easy_option_by_name(byval name as const zstring ptr) as const curl_easyoption ptr
declare function curl_easy_option_by_id(byval id as CURLoption) as const curl_easyoption ptr
declare function curl_easy_option_next(byval prev as const curl_easyoption ptr) as const curl_easyoption ptr
#define CURLINC_HEADER_H

type curl_header
	name as zstring ptr
	value as zstring ptr
	amount as uinteger
	index as uinteger
	origin as ulong
	anchor as any ptr
end type

const CURLH_HEADER = 1 shl 0
const CURLH_TRAILER = 1 shl 1
const CURLH_CONNECT = 1 shl 2
const CURLH_1XX = 1 shl 3
const CURLH_PSEUDO = 1 shl 4

type CURLHcode as long
enum
	CURLHE_OK
	CURLHE_BADINDEX
	CURLHE_MISSING
	CURLHE_NOHEADERS
	CURLHE_NOREQUEST
	CURLHE_OUT_OF_MEMORY
	CURLHE_BAD_ARGUMENT
	CURLHE_NOT_BUILT_IN
end enum

declare function curl_easy_header(byval easy as CURL ptr, byval name as const zstring ptr, byval index as uinteger, byval origin as ulong, byval request as long, byval hout as curl_header ptr ptr) as CURLHcode
declare function curl_easy_nextheader(byval easy as CURL ptr, byval origin as ulong, byval request as long, byval prev as curl_header ptr) as curl_header ptr

end extern
