/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarCustomFields {
    public static String TABLE_NAME = "customfields";
    private Map<String, String> customFields = new HashMap<String, String>();

    protected Map<String, String> getCustomFields() {
        return this.customFields;
    }

    protected void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public void addHarCustomFields(String name, JsonParser jp) throws IOException {
        JsonToken jt = jp.nextToken();
        if (jt == JsonToken.START_OBJECT) {
            jt = jp.nextToken();
            while (jt != JsonToken.END_OBJECT) {
                String childName;
                String newName = jp.getCurrentName();
                if (newName.startsWith("_")) {
                    childName = name + newName;
                    this.addHarCustomFields(childName, jp);
                } else if (jt == JsonToken.FIELD_NAME) {
                    childName = name + "_" + jp.getCurrentName();
                    this.addHarCustomFields(childName, jp);
                }
                jt = jp.nextToken();
            }
        } else {
            String value = jp.getText();
            this.customFields.put(name, value);
        }
    }

    public void writeHar(JsonGenerator g) throws IOException {
        Set<Map.Entry<String, String>> s = this.customFields.entrySet();
        for (Map.Entry<String, String> entry : s) {
            g.writeStringField(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeCustomFieldsJDBC(HarDatabaseConfig config, Type HarTypeFrom, long HarIdFrom, long HarLogId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(tableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + tableName + " (id " + config.getDbAutoGeneratedId() + ", HarTypeFrom INTEGER, HarIdFrom BIGINT, customName " + config.getStringDbType() + ", value " + config.getStringDbType() + ",log_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(tableName);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        long nbInserted = 0L;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("INSERT INTO " + tableName + " (HarTypeFrom,HarIdFrom,customName,value, log_id) VALUES (?,?,?,?,?)", 1);
            Set<Map.Entry<String, String>> s = this.customFields.entrySet();
            for (Map.Entry<String, String> entry : s) {
                ps.setLong(1, HarTypeFrom.ordinal());
                ps.setLong(2, HarIdFrom);
                ps.setString(3, entry.getKey());
                ps.setString(4, entry.getValue());
                ps.setLong(5, HarLogId);
                ps.executeUpdate();
                ++nbInserted;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
        return nbInserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCustomFieldsJDBC(HarDatabaseConfig config, Type harTypeFrom, long harIdFrom) throws SQLException {
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Connection c = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            c = config.getConnection();
            ps = c.prepareStatement("SELECT customName,value FROM " + tableName + " WHERE HarTypeFrom=? AND HarIdFrom=?");
            ps.setLong(1, harTypeFrom.ordinal());
            ps.setLong(2, harIdFrom);
            rs = ps.executeQuery();
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                this.customFields.put(key, value);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long dbLogId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Statement ps = null;
        try {
            ps = c.prepareStatement("DELETE FROM " + tableName + " WHERE log_id = ?");
            ps.setLong(1, dbLogId);
            ps.executeUpdate();
            config.dropTableIfEmpty(c, tableName, config);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void addCustomField(String name, String value) {
        this.customFields.put(name, value);
    }

    public String getCustomFieldValue(String name) {
        return this.customFields.get(name);
    }

    public String toString() {
        Set<Map.Entry<String, String>> s = this.customFields.entrySet();
        StringBuilder builder = new StringBuilder();
        builder.append("");
        Iterator<Map.Entry<String, String>> i = s.iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            builder.append("\"" + entry.getKey() + "\" : \"" + entry.getValue() + "\"");
            if (!i.hasNext()) break;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static enum Type {
        HARLOG,
        HARPAGE,
        HARENTRY,
        HARREQUEST,
        HARCONTENT,
        HARCOOKIE,
        HARBROWSER,
        HARCACHE,
        HARCACHEREQUEST,
        HARENTRYTIMING,
        HARPAGETIMING,
        HARCREATOR,
        HARPOSTDATA,
        HARPOSTDATAPARAM,
        HARHEADER,
        HARQUERYSTRING;

    }
}

