/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.core.ConfigOverlay;

class OverlaidConfigNode
implements ConfigNode {
    private final ConfigOverlay overlay;
    private final String _name;
    private final ConfigNode delegate;
    private final OverlaidConfigNode parent;

    OverlaidConfigNode(ConfigOverlay overlay, String name, OverlaidConfigNode parent, ConfigNode delegate) {
        this.overlay = overlay;
        this._name = name;
        this.delegate = delegate;
        this.parent = parent;
    }

    private List<String> path(List<String> path) {
        if (path == null) {
            path = new ArrayList<String>(5);
        }
        try {
            if (this.parent != null) {
                List<String> list = this.parent.path(path);
                return list;
            }
        }
        finally {
            path.add(this._name);
        }
        return path;
    }

    public ConfigNode get(String name) {
        return this.wrap(this.delegate.get(name), name);
    }

    private ConfigNode wrap(ConfigNode n, String name) {
        return new OverlaidConfigNode(this.overlay, name, this, n);
    }

    public ConfigNode get(String name, Predicate<ConfigNode> test) {
        return this.wrap(this.delegate.get(name, test), name);
    }

    public String txt() {
        return this.overlayText(this.delegate.txt(), null);
    }

    public ConfigNode get(String name, int idx) {
        return this.wrap(this.delegate.get(name, idx), name);
    }

    public String name() {
        return this.delegate.name();
    }

    public Map<String, String> attributes() {
        return this.delegate.attributes();
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public String attr(String name) {
        return this.overlayText(this.delegate.attr(name), name);
    }

    private String overlayText(String def, String appendToPath) {
        Object val;
        List<String> path = this.path(null);
        if (appendToPath != null) {
            path.add(appendToPath);
        }
        return (val = this.overlay.getXPathProperty(path)) == null ? def : val.toString();
    }

    public void forEachChild(Function<ConfigNode, Boolean> fun) {
        this.delegate.forEachChild(fun);
    }
}

