/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyIterNextNodeGen;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class PyIterNextNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Node var2, Object var3);

    public final Object executeCached(VirtualFrame frame, Object iterator) {
        return this.execute((Frame)frame, this, iterator);
    }

    public static Object executeUncached(Object iterator) {
        return PyIterNextNodeGen.getUncached().execute(null, null, iterator);
    }

    @Specialization
    static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object iterator, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotIterNext.CallSlotTpIterNextNode callNext, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile) {
        TpSlots slots = getSlots.execute(inliningTarget, getClassNode.execute(inliningTarget, iterator));
        assert (slots.tp_iternext() != null);
        try {
            return callNext.execute(frame, inliningTarget, slots.tp_iternext(), iterator);
        }
        catch (PException e) {
            e.expectStopIteration(inliningTarget, stopIterationProfile);
            throw TpSlotIterNext.TpIterNextBuiltin.iteratorExhausted();
        }
    }

    @NeverDefault
    public static PyIterNextNode create() {
        return PyIterNextNodeGen.create();
    }

    public static PyIterNextNode getUncached() {
        return PyIterNextNodeGen.getUncached();
    }
}

