/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.Map;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.Position;

public class EntityImageTips
extends AbstractEntityImage {
    private final HColor noteBackgroundColor;
    private final HColor borderColor;
    private final Bibliotekon bibliotekon;
    private final Style style;
    private final double ySpacing = 10.0;

    public EntityImageTips(Entity entity, Bibliotekon bibliotekon) {
        super(entity);
        this.bibliotekon = bibliotekon;
        this.style = this.getDefaultStyleDefinition(this.getStyleName()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        this.noteBackgroundColor = entity.getColors().getColor(ColorType.BACK) == null ? this.style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet()) : entity.getColors().getColor(ColorType.BACK);
        this.borderColor = this.style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
    }

    private StyleSignature getDefaultStyleDefinition(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, sname, SName.note).withTOBECHANGED(this.getStereo());
    }

    private Position getPosition() {
        if (this.getEntity().getName().endsWith(Position.RIGHT.name())) {
            return Position.RIGHT;
        }
        return Position.LEFT;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (Map.Entry<String, Display> ent : this.getEntity().getTips().entrySet()) {
            Display display = ent.getValue();
            XDimension2D dim = this.getOpale(display).calculateDimension(stringBounder);
            height += dim.getHeight();
            height += 10.0;
            width = Math.max(width, dim.getWidth());
        }
        return new XDimension2D(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Entity tmp = this.getEntity();
        Entity other = this.bibliotekon.getOnlyOther(tmp);
        if (other == null) {
            System.err.println("Error1 in EntityImageTips");
            return;
        }
        SvekNode nodeMe = this.bibliotekon.getNode(this.getEntity());
        SvekNode nodeOther = this.bibliotekon.getNode(other);
        if (nodeOther == null) {
            System.err.println("Error2 in EntityImageTips");
            return;
        }
        XPoint2D positionOther = nodeOther.getPosition();
        this.bibliotekon.getNode(this.getEntity());
        Position position = this.getPosition();
        Direction direction = position.reverseDirection();
        XPoint2D positionMe = nodeMe.getPosition();
        double height = 0.0;
        for (Map.Entry<String, Display> ent : this.getEntity().getTips().entrySet()) {
            Display display = ent.getValue();
            String member = ent.getKey();
            CharSequence bestMatch = nodeOther.getBestMatch(member);
            if (bestMatch == null) {
                return;
            }
            XRectangle2D memberPosition = nodeOther.getImage().getInnerPosition(bestMatch.toString(), stringBounder);
            if (memberPosition == null) {
                return;
            }
            Opale opale = this.getOpale(display);
            XDimension2D dim = opale.calculateDimension(stringBounder);
            XPoint2D pp1 = new XPoint2D(0.0, dim.getHeight() / 2.0);
            double x = positionOther.getX() - positionMe.getX();
            if (direction == Direction.RIGHT && x < 0.0) {
                direction = direction.getInv();
            }
            x = direction == Direction.LEFT ? (x += memberPosition.getMaxX()) : (x += 4.0);
            double y = positionOther.getY() - positionMe.getY() - height + memberPosition.getCenterY();
            XPoint2D pp2 = new XPoint2D(x, y);
            opale.setOpale(direction, pp1, pp2);
            opale.drawU(UGraphicStencil.create(ug, dim));
            ug = ug.apply(UTranslate.dy(dim.getHeight() + 10.0));
            height += dim.getHeight();
            height += 10.0;
        }
    }

    private Opale getOpale(Display display) {
        double shadowing = this.style.getShadowing();
        FontConfiguration fc = this.style.getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        UStroke stroke = this.style.getStroke();
        TextBlock textBlock = BodyFactory.create3(display, this.getSkinParam(), HorizontalAlignment.LEFT, fc, this.style.wrapWidth(), this.style);
        return new Opale(shadowing, this.borderColor, this.noteBackgroundColor, textBlock, true, stroke);
    }
}

