/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.algorithm.seismic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.opensearch.neuralsearch.sparse.algorithm.ClusteringAlgorithm;
import org.opensearch.neuralsearch.sparse.algorithm.PostingsProcessingUtils;
import org.opensearch.neuralsearch.sparse.data.DocWeight;
import org.opensearch.neuralsearch.sparse.data.DocumentCluster;

public class SeismicPostingClusterer {
    private static final int MINIMAL_DOC_SIZE_TO_CLUSTER = 10;
    private final int nPostings;
    private final ClusteringAlgorithm clusteringAlgorithm;

    public SeismicPostingClusterer(int nPostings, ClusteringAlgorithm clusteringAlgorithm) {
        this.nPostings = nPostings;
        this.clusteringAlgorithm = clusteringAlgorithm;
    }

    private List<DocWeight> preprocess(List<DocWeight> postings) {
        return PostingsProcessingUtils.getTopK(postings, this.nPostings);
    }

    public List<DocumentCluster> cluster(List<DocWeight> postings) throws IOException {
        if (CollectionUtils.isEmpty(postings)) {
            return Collections.emptyList();
        }
        ArrayList<DocWeight> postingsCopy = new ArrayList<DocWeight>(postings);
        List<DocWeight> preprocessed = this.preprocess(postingsCopy);
        if (preprocessed.isEmpty()) {
            return Collections.emptyList();
        }
        if (preprocessed.size() < 10) {
            return Collections.singletonList(new DocumentCluster(null, preprocessed, true));
        }
        return this.clusteringAlgorithm.cluster(preprocessed);
    }
}

