/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.node.liveness;

import java.io.IOException;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public final class LivenessResponse
extends ActionResponse {
    private DiscoveryNode node;
    private ClusterName clusterName;

    public LivenessResponse() {
    }

    public LivenessResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterName = new ClusterName(in);
        this.node = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
    }

    public LivenessResponse(ClusterName clusterName, DiscoveryNode node) {
        this.node = node;
        this.clusterName = clusterName;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.node);
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public DiscoveryNode getDiscoveryNode() {
        return this.node;
    }
}

