/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public class PartialDelegatingMethod
extends DynamicMethod {
    private final CacheEntry entry;
    private final boolean findImplementer;

    public PartialDelegatingMethod(RubyModule implementationClass, CacheEntry entry, Visibility visibility) {
        super(implementationClass, visibility, entry.method.getName());
        this.entry = entry;
        boolean findImplementer = true;
        if (entry.method instanceof AbstractIRMethod) {
            findImplementer = ((AbstractIRMethod)entry.method).needsToFindImplementer();
        }
        this.findImplementer = findImplementer;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, this.calculateSourceModule(self2, klazz)), name2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, this.calculateSourceModule(self2, klazz)), name2, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, this.calculateSourceModule(self2, klazz)), name2, arg1, arg2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, this.calculateSourceModule(self2, klazz)), name2, arg1, arg2, arg3);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), name2, args2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), name2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), name2, arg1, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), name2, arg1, arg2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), name2, arg1, arg2, arg3, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
        return this.entry.method.call(context, self2, this.calculateSourceModule(self2, klazz), name2, args2, block);
    }

    @Override
    public DynamicMethod dup() {
        return new PartialDelegatingMethod(this.implementationClass, this.entry, this.getVisibility());
    }

    @Override
    public long getSerialNumber() {
        return this.entry.method.getSerialNumber();
    }

    @Override
    public DynamicMethod getRealMethod() {
        return this.entry.method.getRealMethod();
    }

    @Override
    @Deprecated(since="9.3.0.0")
    public Arity getArity() {
        return this.entry.method.getArity();
    }

    @Override
    public Signature getSignature() {
        return this.entry.method.getSignature();
    }

    @Override
    public RubyModule getDefinedClass() {
        RubyModule definedClass = this.definedClass;
        if (definedClass != null) {
            return definedClass;
        }
        return this.entry.method.getDefinedClass();
    }

    private RubyModule calculateSourceModule(IRubyObject self2, RubyModule incomingSourceModule) {
        if (this.findImplementer) {
            return Helpers.findImplementerIfNecessary(self2.getMetaClass(), this.entry.method.getImplementationClass());
        }
        return incomingSourceModule;
    }
}

