/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.runtime;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.security.action.GetIntegerAction;

public final class RuntimeUtil {
    private static final Log runtimeLog = Log.getLog("sun.rmi.runtime", null, false);
    private static final int schedulerThreads = AccessController.doPrivileged(new GetIntegerAction("sun.rmi.runtime.schedulerThreads", 1));
    private static final Permission GET_INSTANCE_PERMISSION = new RuntimePermission("sun.rmi.runtime.RuntimeUtil.getInstance");
    private static final RuntimeUtil instance = new RuntimeUtil();
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(schedulerThreads, new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable runnable) {
            try {
                return AccessController.doPrivileged(new NewThreadAction(runnable, "Scheduler(" + this.count.getAndIncrement() + ")", true));
            }
            catch (Throwable throwable) {
                runtimeLog.log(Level.WARNING, "scheduler thread factory throws", throwable);
                return null;
            }
        }
    });

    private RuntimeUtil() {
    }

    private static RuntimeUtil getInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(GET_INSTANCE_PERMISSION);
        }
        return instance;
    }

    public ScheduledThreadPoolExecutor getScheduler() {
        return this.scheduler;
    }

    public static class GetInstanceAction
    implements PrivilegedAction<RuntimeUtil> {
        @Override
        public RuntimeUtil run() {
            return RuntimeUtil.getInstance();
        }
    }
}

