/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    public static final int DES_KEY_LEN = 8;
    private byte[] key;
    private static final byte[][] WEAK_KEYS = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {-2, -2, -2, -2, -2, -2, -2, -2}, {31, 31, 31, 31, 14, 14, 14, 14}, {-32, -32, -32, -32, -15, -15, -15, -15}, {1, -2, 1, -2, 1, -2, 1, -2}, {31, -32, 31, -32, 14, -15, 14, -15}, {1, -32, 1, -32, 1, -15, 1, -15}, {31, -2, 31, -2, 14, -2, 14, -2}, {1, 31, 1, 31, 1, 14, 1, 14}, {-32, -2, -32, -2, -15, -2, -15, -2}, {-2, 1, -2, 1, -2, 1, -2, 1}, {-32, 31, -32, 31, -15, 14, -15, 14}, {-32, 1, -32, 1, -15, 1, -15, 1}, {-2, 31, -2, 31, -2, 14, -2, 14}, {31, 1, 31, 1, 14, 1, 14, 1}, {-2, -32, -2, -32, -2, -15, -2, -15}};

    public DESKeySpec(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("Wrong key size");
        }
        this.key = new byte[8];
        System.arraycopy(byArray, n, this.key, 0, 8);
    }

    public byte[] getKey() {
        return (byte[])this.key.clone();
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray == null) {
            throw new InvalidKeyException("null key");
        }
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("Wrong key size");
        }
        for (int i = 0; i < 8; ++i) {
            int n2;
            if (((n2 = Integer.bitCount(byArray[n++] & 0xFF)) & 1) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isWeak(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray == null) {
            throw new InvalidKeyException("null key");
        }
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("Wrong key size");
        }
        for (int i = 0; i < WEAK_KEYS.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < 8 && bl; ++j) {
                if (WEAK_KEYS[i][j] == byArray[j + n]) continue;
                bl = false;
            }
            if (!bl) continue;
            return bl;
        }
        return false;
    }
}

