/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=-2147483637)
public final class GradleSourceSetDataService
extends AbstractModuleDataService<GradleSourceSetData> {
    @NotNull
    public Key<GradleSourceSetData> getTargetDataKey() {
        Key<GradleSourceSetData> key = GradleSourceSetData.KEY;
        if (key == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @NotNull
    public String getExternalModuleType() {
        return "sourceSet";
    }

    @NotNull
    protected Module createModule(@NotNull DataNode<GradleSourceSetData> sourceSetModuleNode, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String sourceSetModuleInternalName;
        if (sourceSetModuleNode == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(2);
        }
        DataNode parentModuleNode = sourceSetModuleNode.getParent();
        assert (parentModuleNode != null);
        Module parentModule = (Module)parentModuleNode.getUserData(MODULE_KEY);
        assert (parentModule != null);
        String projectPath = ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).getLinkedExternalProjectPath();
        String actualModuleName = modelsProvider.getModifiableModuleModel().getActualName(parentModule);
        ExternalProjectSettings settings = ExternalSystemApiUtil.getSettings((Project)parentModule.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID).getLinkedProjectSettings(projectPath);
        if (settings != null && settings.isUseQualifiedModuleNames() && !(sourceSetModuleInternalName = ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).getInternalName()).startsWith(actualModuleName)) {
            String sourceSetName = ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).getModuleName();
            String adjustedInternalName = GradleSourceSetDataService.findDeduplicatedModuleName(actualModuleName + "." + sourceSetName, modelsProvider);
            ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).setInternalName(adjustedInternalName);
        }
        Module module = super.createModule(sourceSetModuleNode, modelsProvider);
        if (module == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(3);
        }
        return module;
    }

    @NotNull
    private static String findDeduplicatedModuleName(@NotNull String moduleName, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String nextModuleNameCandidate;
        Module ideModule;
        if (moduleName == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(4);
        }
        if (modelsProvider == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(5);
        }
        if ((ideModule = modelsProvider.findIdeModule(moduleName)) == null) {
            String string = moduleName;
            if (string == null) {
                GradleSourceSetDataService.$$$reportNull$$$0(6);
            }
            return string;
        }
        int i = 0;
        while ((ideModule = modelsProvider.findIdeModule(nextModuleNameCandidate = moduleName + "~" + ++i)) != null) {
        }
        String string = nextModuleNameCandidate;
        if (string == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetModuleNode";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeduplicatedModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDeduplicatedModuleName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

