/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.other;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

public final class GrSortMapKeysIntention
extends GrPsiUpdateIntention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        PsiElement pparent;
        PsiElement parent;
        if (element == null) {
            GrSortMapKeysIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GrSortMapKeysIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            GrSortMapKeysIntention.$$$reportNull$$$0(2);
        }
        if ((parent = element.getParent()) instanceof GrArgumentLabel && (pparent = parent.getParent().getParent()) instanceof GrListOrMap) {
            GrNamedArgument[] namedArgs;
            GrListOrMap map2 = (GrListOrMap)pparent;
            if (!ErrorUtil.containsError(pparent) && map2.getInitializers().length == 0 && GrSortMapKeysIntention.isLiteralKeys(namedArgs = map2.getNamedArguments())) {
                GrListOrMap newMap = GrSortMapKeysIntention.constructNewMap(namedArgs, context.project());
                map2.replace(newMap);
            }
        }
    }

    @NotNull
    private static GrListOrMap constructNewMap(GrNamedArgument @NotNull [] args, Project project) {
        if (args == null) {
            GrSortMapKeysIntention.$$$reportNull$$$0(3);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Arrays.sort(args, (o1, o2) -> {
            String l1 = o1.getLabelName();
            String l2 = o2.getLabelName();
            assert (l1 != null && l2 != null);
            return l1.compareTo(l2);
        });
        for (GrNamedArgument arg : args) {
            builder.append(arg.getText()).append(",\n");
        }
        builder.replace(builder.length() - 2, builder.length(), "]");
        GrListOrMap grListOrMap = (GrListOrMap)GroovyPsiElementFactory.getInstance(project).createExpressionFromText(builder);
        if (grListOrMap == null) {
            GrSortMapKeysIntention.$$$reportNull$$$0(4);
        }
        return grListOrMap;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                PsiElement parent;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((parent = element.getParent()) instanceof GrArgumentLabel)) {
                    return false;
                }
                if (((GrArgumentLabel)parent).getNameElement() != element) {
                    return false;
                }
                PsiElement grandParent = parent.getParent();
                if (grandParent == null) {
                    return false;
                }
                PsiElement grandGrandParent = grandParent.getParent();
                if (!(grandGrandParent instanceof GrListOrMap)) {
                    return false;
                }
                GrListOrMap map2 = (GrListOrMap)grandGrandParent;
                return !ErrorUtil.containsError(map2) && map2.getInitializers().length == 0 && GrSortMapKeysIntention.isLiteralKeys(map2.getNamedArguments());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/other/GrSortMapKeysIntention$1", "satisfiedBy"));
            }
        };
    }

    private static boolean isLiteralKeys(GrNamedArgument[] args) {
        return ContainerUtil.and((Object[])args, it -> it.getLabel() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/other/GrSortMapKeysIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/other/GrSortMapKeysIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "constructNewMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "constructNewMap";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

