#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-8EloIznsu3rBLx4rfcWJlI
key:                  trifecta-2.1.4-8EloIznsu3rBLx4rfcWJlI
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  551243a15b874cb91e6559697ba76266
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-8EloIznsu3rBLx4rfcWJlI
depends:
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-AwQ5sxh61E8JpZEnYXtMmK
    blaze-html-0.9.2.0-AcUIY0JSEhx2Asds2f6X2X
    blaze-markup-0.8.3.0-65ZtuCuNbQD3EQRkgrMobs bytestring-0.11.5.3
    charset-0.3.12-CggMTjFbh6xC1ABtAblChj
    comonad-5.0.9-9XYCuoUxdGmGG2uu9BeGYY containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-5ElOzDcrhRpGI1xqfKKRcf
    ghc-prim-0.9.1 hashable-1.4.6.0-HsdqsQ7iDyd40AcboGWr8K
    indexed-traversable-0.1.4-10ilYqh2nxEny8IgMDEXE
    lens-5.3.2-Gri7akg07hN4ZkbavAwqWU mtl-2.2.2
    parsers-0.12.12-LrAtr2YQVMNBkASpTqmvwP
    prettyprinter-1.7.1-BNC6JafOhDbB8Lc4c1jpfV
    prettyprinter-ansi-terminal-1.1.3-6nflTrJsCkLJKMI8qneRUW
    profunctors-5.6.3-JcgvHChb6Un52eXlatjwDF
    reducers-3.12.5-JHFUC3KI5UX5ywxg1x72m2 transformers-0.5.6.2
    unordered-containers-0.2.20-DjNgsRwGYvfHy5WsKzKUzR
    utf8-string-1.0.2-9Em8uVxkJRhLhA62Ke5gub

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

