/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.unexported.buildinit.plugins.internal.maven;

import java.io.File;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.buildinit.InsecureProtocolOption;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.unexported.buildinit.plugins.internal.maven.Maven2Gradle;
import org.gradle.unexported.buildinit.plugins.internal.maven.MavenConversionException;
import org.gradle.unexported.buildinit.plugins.internal.maven.MavenProjectsCreator;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;

public abstract class Maven2GradleWorkAction
implements WorkAction<Maven2GradleWorkParameters> {
    public void execute() {
        Maven2GradleWorkParameters params = (Maven2GradleWorkParameters)this.getParameters();
        File pom = ((RegularFile)params.getWorkingDir().file("pom.xml").get()).getAsFile();
        try {
            Set<MavenProject> mavenProjects = new MavenProjectsCreator().create((Settings)params.getMavenSettings().get(), pom);
            new Maven2Gradle(mavenProjects, (Directory)params.getWorkingDir().get(), (BuildInitDsl)params.getDsl().get(), (Boolean)params.getUseIncubatingAPIs().get(), (InsecureProtocolOption)((Object)params.getInsecureProtocolOption().get())).convert();
        }
        catch (Exception exception) {
            throw new MavenConversionException(String.format("Could not convert Maven POM %s to a Gradle build.", pom), exception);
        }
    }

    public static interface Maven2GradleWorkParameters
    extends WorkParameters {
        public DirectoryProperty getWorkingDir();

        public Property<BuildInitDsl> getDsl();

        public Property<Boolean> getUseIncubatingAPIs();

        public Property<Settings> getMavenSettings();

        public Property<InsecureProtocolOption> getInsecureProtocolOption();
    }
}

