---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 脆弱性のアーカイブ
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- は、`vulnerability_archival`という名前の[フラグ](../../../administration/feature_flags/_index.md)を付けて、GitLab 18.0で導入されました。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

GitLabデータベースのパフォーマンスを維持するため、脆弱性はデータベースから毎月アーカイブされます。最後に更新されたのが1年以上前の脆弱性は、アーカイブされます。脆弱性は、ステータスが変更されたときなど、変更が行われるたびに更新されます。

アーカイブされた脆弱性は、さらに3年間ダウンロードできます。その後、削除されます。

セキュリティダッシュボードやバリューストリームダッシュボードなどの脆弱性のメトリクスには、アーカイブされた脆弱性に関する統計が含まれています。

## アーカイブ処理 {#archival-process}

脆弱性のアーカイブ処理は毎月実行され、次の処理が行われます:  

- 最後に更新されたのが12か月以上前の脆弱性をアーカイブします。

  アーカイブされた脆弱性は、脆弱性レポートから削除されます。詳細を取得するには、関連する脆弱性アーカイブをダウンロードしてください。

- 3年以上前に作成されたアーカイブを削除します。

## 脆弱性のアーカイブ {#vulnerability-archive}

脆弱性アーカイブは、特定の月または年、あるいは特定の期間にアーカイブされたすべての脆弱性の詳細を含むCSVファイルです。

### 脆弱性アーカイブのダウンロード {#download-a-vulnerability-archive}

脆弱性アーカイブをダウンロードして、含まれている詳細を検索または分析します。

前提要件: 

- プロジェクトのオーナーロール、または`read_vulnerability_archive`の権限が必要です。

脆弱性アーカイブをダウンロードするには、次の手順に従います:  

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **セキュリティ設定**を選択し、**脆弱性管理**を選択します。
1. アーカイブされたすべての脆弱性の詳細をダウンロードするには、次の手順に従います:  
   - 特定の年の場合、その年の行で**すべてダウンロード**を選択します。
   - 特定の年と月の場合、年を展開し、その月の行で**ダウンロード**（{{< icon name="download" >}}）を選択します。
   - 特定の日付範囲の場合、**From**フィールドと**To**フィールドに日付を入力し、**ダウンロード**を選択します。

選択した脆弱性アーカイブは、CSVファイルとしてダウンロードされます。
