/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.color.Illuminants;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ChromaticAdaption;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.OKLABColorValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import io.sf.jclf.math.linear3.Matrices;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.DOMException;

class LABColorImpl
extends BaseColor
implements LABColor {
    private static final long serialVersionUID = 2L;
    private final BaseColor.Space colorSpace;
    private final String strSpace;
    private PrimitiveValue lightness = null;
    private PrimitiveValue a = null;
    private PrimitiveValue b = null;

    LABColorImpl(BaseColor.Space colorSpace, String strSpace) {
        this.colorSpace = colorSpace;
        this.strSpace = strSpace;
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LAB;
    }

    @Override
    public String getColorSpace() {
        return this.strSpace;
    }

    @Override
    BaseColor.Space getSpace() {
        return this.colorSpace;
    }

    @Override
    void set(BaseColor color) {
        super.set(color);
        LABColorImpl setfrom = (LABColorImpl)color;
        this.lightness = setfrom.getLightness();
        this.a = setfrom.getA();
        this.b = setfrom.getB();
    }

    @Override
    public NumberValue component(String component) {
        NumberValue ret;
        switch (component) {
            case "l": {
                float pcntDiv = BaseColor.Space.OK_Lab.equals((Object)this.colorSpace) ? 100.0f : 1.0f;
                ret = this.numberComponent((CSSTypedValue)((Object)this.getLightness()), pcntDiv);
                break;
            }
            case "a": {
                ret = this.numberComponent((CSSTypedValue)((Object)this.getA()), 1.0f);
                break;
            }
            case "b": {
                ret = this.numberComponent((CSSTypedValue)((Object)this.getB()), 1.0f);
                break;
            }
            case "alpha": {
                ret = this.numberComponent((CSSTypedValue)((Object)this.alpha), 100.0f);
                break;
            }
            default: {
                return null;
            }
        }
        return ret;
    }

    @Override
    public PrimitiveValue item(int index) {
        switch (index) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getLightness();
            }
            case 2: {
                return this.getA();
            }
            case 3: {
                return this.getB();
            }
        }
        return null;
    }

    @Override
    void setComponent(int index, PrimitiveValue component) {
        switch (index) {
            case 0: {
                this.setAlpha(component);
                break;
            }
            case 1: {
                this.setLightness(component);
                break;
            }
            case 2: {
                this.setA(component);
                break;
            }
            case 3: {
                this.setB(component);
            }
        }
    }

    @Override
    public PrimitiveValue getLightness() {
        return this.lightness;
    }

    public void setLightness(PrimitiveValue lightness) {
        boolean specified;
        int maxDigits;
        float factor;
        if (BaseColor.Space.OK_Lab.equals((Object)this.colorSpace)) {
            factor = 0.01f;
            maxDigits = 6;
            specified = false;
        } else {
            factor = 1.0f;
            maxDigits = 4;
            specified = true;
        }
        this.lightness = LABColorImpl.normalizePcntToNumber(lightness, factor, maxDigits, specified);
    }

    @Override
    public PrimitiveValue getA() {
        return this.a;
    }

    public void setA(PrimitiveValue a) {
        float factor = BaseColor.Space.OK_Lab.equals((Object)this.colorSpace) ? 0.004f : 1.25f;
        this.a = LABColorImpl.normalizePcntToNumber(a, factor, 5, false);
    }

    @Override
    public PrimitiveValue getB() {
        return this.b;
    }

    public void setB(PrimitiveValue b) {
        float factor = BaseColor.Space.OK_Lab.equals((Object)this.colorSpace) ? 0.004f : 1.25f;
        this.b = LABColorImpl.normalizePcntToNumber(b, factor, 5, false);
    }

    @Override
    boolean hasPercentageComponent() {
        return this.lightness != null && this.lightness.getUnitType() == 2;
    }

    @Override
    boolean hasConvertibleComponents() {
        return LABColorImpl.isConvertibleComponent(this.getA()) && LABColorImpl.isConvertibleComponent(this.getB()) && LABColorImpl.isConvertibleComponent(this.getLightness());
    }

    @Override
    int getMaximumFractionDigits() {
        return 5;
    }

    @Override
    void setColorComponents(double[] lab) {
        NumberValue l = NumberValue.createCSSNumberValue((short)0, (float)lab[0]);
        l.setSubproperty(true);
        l.setAbsolutizedUnit();
        if (this.getSpace() == BaseColor.Space.OK_Lab) {
            l.setMaximumFractionDigits(6);
        } else {
            l.setMaximumFractionDigits(4);
        }
        this.setLightness(l);
        NumberValue a = NumberValue.createCSSNumberValue((short)0, (float)lab[1]);
        a.setSubproperty(true);
        a.setAbsolutizedUnit();
        a.setMaximumFractionDigits(this.getMaximumFractionDigits());
        this.setA(a);
        NumberValue b = NumberValue.createCSSNumberValue((short)0, (float)lab[2]);
        b.setSubproperty(true);
        b.setAbsolutizedUnit();
        b.setMaximumFractionDigits(this.getMaximumFractionDigits());
        this.setB(b);
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] lab = new double[]{ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness())), ColorUtil.floatNumber((CSSTypedValue)((Object)this.getA())), ColorUtil.floatNumber((CSSTypedValue)((Object)this.getB()))};
        return lab;
    }

    @Override
    double[] toSRGB(boolean clamp) {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float light = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness()));
        float a = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getA()));
        float b = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getB()));
        double[] rgb = new double[3];
        SRGBColorProfile profile = new SRGBColorProfile();
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            ColorUtil.oklabToRGB(light, a, b, clamp, profile, rgb);
        } else {
            ColorUtil.labToClampedRGB(light, a, b, clamp, profile, rgb);
        }
        return rgb;
    }

    @Override
    public double[] toXYZ(Illuminant white) {
        double[] xyz;
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float light = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness()));
        float a = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getA()));
        float b = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getB()));
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            xyz = ColorUtil.oklabToXyzD65(light, a, b);
            if (white == Illuminant.D50) {
                xyz = ColorUtil.d65xyzToD50(xyz);
            }
        } else {
            xyz = ColorUtil.labToXYZd50(light, a, b);
            if (white == Illuminant.D65) {
                xyz = ColorUtil.d50xyzToD65(xyz);
            }
        }
        return xyz;
    }

    @Override
    public double[] toXYZ(double[] white) {
        double[] xyz;
        double[] lab = this.toNumberArray();
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            xyz = ColorUtil.oklabToXyzD65(lab[0], lab[1], lab[2]);
            if (!Arrays.equals(Illuminants.whiteD65, white)) {
                double[][] cam = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD65, white, cam);
                double[] result = new double[3];
                Matrices.multiplyByVector3((double[][])cam, (double[])xyz, (double[])result);
                xyz = result;
            }
        } else {
            xyz = ColorUtil.labToXYZd50(lab[0], lab[1], lab[2]);
            if (!Arrays.equals(Illuminants.whiteD50, white)) {
                double[][] cam = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD50, white, cam);
                double[] result = new double[3];
                Matrices.multiplyByVector3((double[][])cam, (double[])xyz, (double[])result);
                xyz = result;
            }
        }
        return xyz;
    }

    @Override
    public String toString() {
        BufferSimpleWriter wri = new BufferSimpleWriter();
        try {
            this.writeCssText((SimpleWriter)wri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wri.toString();
    }

    void writeCssText(SimpleWriter wri) throws IOException {
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            wri.write((CharSequence)"oklab(");
        } else {
            wri.write((CharSequence)"lab(");
        }
        this.lightness.writeCssText(wri);
        wri.write(' ');
        this.a.writeCssText(wri);
        wri.write(' ');
        this.b.writeCssText(wri);
        if (this.isNonOpaque()) {
            wri.write((CharSequence)" / ");
            this.appendAlphaChannel(wri);
        }
        wri.write(')');
    }

    @Override
    public String toMinifiedString() {
        StringBuilder buf = new StringBuilder(20);
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            buf.append("oklab(");
        } else {
            buf.append("lab(");
        }
        buf.append(this.lightness.getMinifiedCssText("color")).append(' ').append(this.a.getMinifiedCssText("color")).append(' ').append(this.b.getMinifiedCssText("color"));
        if (this.isNonOpaque()) {
            buf.append('/');
            this.appendAlphaChannelMinified(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = Objects.hash(new Object[]{this.getSpace()});
        result = 31 * result + (this.lightness == null ? 0 : this.lightness.hashCode());
        result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
        result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
        result = 31 * result + this.alpha.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LABColorImpl other = (LABColorImpl)obj;
        if (this.colorSpace != other.colorSpace) {
            return false;
        }
        if (this.lightness == null ? other.lightness != null : !this.lightness.equals(other.lightness)) {
            return false;
        }
        if (this.a == null ? other.a != null : !this.a.equals(other.a)) {
            return false;
        }
        if (this.b == null ? other.b != null : !this.b.equals(other.b)) {
            return false;
        }
        return this.alpha.equals(other.alpha);
    }

    @Override
    public ColorValue packInValue() {
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            return new OKLABColorValue(this);
        }
        return new LABColorValue(this);
    }

    @Override
    public LABColorImpl clone() {
        LABColorImpl clon = new LABColorImpl(this.colorSpace, this.strSpace);
        clon.alpha = this.alpha.clone();
        if (this.lightness != null) {
            clon.lightness = this.lightness.clone();
        }
        if (this.a != null) {
            clon.a = this.a.clone();
        }
        if (this.b != null) {
            clon.b = this.b.clone();
        }
        return clon;
    }
}

