import React, { type ReactNode } from 'react';
import { type Except } from 'type-fest';
import { type Styles } from '../styles.js';
import { type DOMElement } from '../dom.js';
export type Props = Except<Styles, 'textWrap'> & {
    /**
    A label for the element for screen readers.
    */
    readonly 'aria-label'?: string;
    /**
    Hide the element from screen readers.
    */
    readonly 'aria-hidden'?: boolean;
    /**
    The role of the element.
    */
    readonly 'aria-role'?: 'button' | 'checkbox' | 'combobox' | 'list' | 'listbox' | 'listitem' | 'menu' | 'menuitem' | 'option' | 'progressbar' | 'radio' | 'radiogroup' | 'tab' | 'tablist' | 'table' | 'textbox' | 'timer' | 'toolbar';
    /**
    The state of the element.
    */
    readonly 'aria-state'?: {
        readonly busy?: boolean;
        readonly checked?: boolean;
        readonly disabled?: boolean;
        readonly expanded?: boolean;
        readonly multiline?: boolean;
        readonly multiselectable?: boolean;
        readonly readonly?: boolean;
        readonly required?: boolean;
        readonly selected?: boolean;
    };
    /**
     * Make the element opaque even if no background color is specified.
     */
    readonly opaque?: boolean;
    /**
     * Make the element sticky.
     */
    readonly sticky?: boolean;
    /**
     * Content to render when the element is sticky.
     */
    readonly stickyChildren?: ReactNode;
};
/**
`<Box>` is an essential Ink component to build your layout. It's like `<div style="display: flex">` in the browser.
*/
declare const Box: React.ForwardRefExoticComponent<{
    readonly position?: "absolute" | "relative" | undefined;
    readonly columnGap?: number | undefined;
    readonly rowGap?: number | undefined;
    readonly gap?: number | undefined;
    readonly margin?: number | undefined;
    readonly marginX?: number | undefined;
    readonly marginY?: number | undefined;
    readonly marginTop?: number | undefined;
    readonly marginBottom?: number | undefined;
    readonly marginLeft?: number | undefined;
    readonly marginRight?: number | undefined;
    readonly padding?: number | undefined;
    readonly paddingX?: number | undefined;
    readonly paddingY?: number | undefined;
    readonly paddingTop?: number | undefined;
    readonly paddingBottom?: number | undefined;
    readonly paddingLeft?: number | undefined;
    readonly paddingRight?: number | undefined;
    readonly flexGrow?: number | undefined;
    readonly flexShrink?: number | undefined;
    readonly flexDirection?: "row" | "column" | "row-reverse" | "column-reverse" | undefined;
    readonly flexBasis?: number | string | undefined;
    readonly flexWrap?: "nowrap" | "wrap" | "wrap-reverse" | undefined;
    readonly alignItems?: "flex-start" | "center" | "flex-end" | "stretch" | undefined;
    readonly alignSelf?: "flex-start" | "center" | "flex-end" | "auto" | undefined;
    readonly justifyContent?: "flex-start" | "flex-end" | "space-between" | "space-around" | "space-evenly" | "center" | undefined;
    readonly width?: number | string | undefined;
    readonly height?: number | string | undefined;
    readonly minWidth?: number | string | undefined;
    readonly minHeight?: number | string | undefined;
    readonly maxWidth?: number | string | undefined;
    readonly maxHeight?: number | string | undefined;
    readonly display?: "flex" | "none" | undefined;
    readonly borderStyle?: (keyof import("cli-boxes").Boxes | import("cli-boxes").BoxStyle) | undefined;
    readonly borderTop?: boolean | undefined;
    readonly borderBottom?: boolean | undefined;
    readonly borderLeft?: boolean | undefined;
    readonly borderRight?: boolean | undefined;
    readonly borderColor?: import("type-fest").LiteralUnion<import("ansi-styles").ForegroundColorName, string> | undefined;
    readonly borderTopColor?: import("type-fest").LiteralUnion<import("ansi-styles").ForegroundColorName, string> | undefined;
    readonly borderBottomColor?: import("type-fest").LiteralUnion<import("ansi-styles").ForegroundColorName, string> | undefined;
    readonly borderLeftColor?: import("type-fest").LiteralUnion<import("ansi-styles").ForegroundColorName, string> | undefined;
    readonly borderRightColor?: import("type-fest").LiteralUnion<import("ansi-styles").ForegroundColorName, string> | undefined;
    readonly borderDimColor?: boolean | undefined;
    readonly borderTopDimColor?: boolean | undefined;
    readonly borderBottomDimColor?: boolean | undefined;
    readonly borderLeftDimColor?: boolean | undefined;
    readonly borderRightDimColor?: boolean | undefined;
    readonly overflow?: "visible" | "hidden" | "scroll" | undefined;
    readonly overflowX?: "visible" | "hidden" | "scroll" | undefined;
    readonly overflowY?: "visible" | "hidden" | "scroll" | undefined;
    readonly backgroundColor?: import("type-fest").LiteralUnion<import("ansi-styles").ForegroundColorName, string> | undefined;
    readonly scrollTop?: number | undefined;
    readonly scrollLeft?: number | undefined;
    readonly scrollbarThumbColor?: import("type-fest").LiteralUnion<import("ansi-styles").ForegroundColorName, string> | undefined;
    readonly userSelect?: "auto" | "none" | "text" | "all" | undefined;
} & {
    /**
    A label for the element for screen readers.
    */
    readonly 'aria-label'?: string;
    /**
    Hide the element from screen readers.
    */
    readonly 'aria-hidden'?: boolean;
    /**
    The role of the element.
    */
    readonly 'aria-role'?: "button" | "checkbox" | "combobox" | "list" | "listbox" | "listitem" | "menu" | "menuitem" | "option" | "progressbar" | "radio" | "radiogroup" | "tab" | "tablist" | "table" | "textbox" | "timer" | "toolbar";
    /**
    The state of the element.
    */
    readonly 'aria-state'?: {
        readonly busy?: boolean;
        readonly checked?: boolean;
        readonly disabled?: boolean;
        readonly expanded?: boolean;
        readonly multiline?: boolean;
        readonly multiselectable?: boolean;
        readonly readonly?: boolean;
        readonly required?: boolean;
        readonly selected?: boolean;
    };
    /**
     * Make the element opaque even if no background color is specified.
     */
    readonly opaque?: boolean;
    /**
     * Make the element sticky.
     */
    readonly sticky?: boolean;
    /**
     * Content to render when the element is sticky.
     */
    readonly stickyChildren?: ReactNode;
} & {
    children?: ReactNode | undefined;
} & React.RefAttributes<DOMElement>>;
export default Box;
