/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public abstract class SelectionAction
extends WorkbenchPartAction {
    private ISelectionProvider provider;
    private ISelection selection;

    protected SelectionAction(IWorkbenchPart part, int style) {
        super(part, style);
    }

    protected SelectionAction(IWorkbenchPart part) {
        super(part);
    }

    @Override
    public void dispose() {
        this.selection = StructuredSelection.EMPTY;
        super.dispose();
    }

    protected List<Object> getSelectedObjects() {
        if (!(this.getSelection() instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        return ((IStructuredSelection)this.getSelection()).toList();
    }

    protected final List<EditPart> getSelectedEditParts() {
        List<Object> selectedObjects = this.getSelectedObjects();
        if (selectedObjects.isEmpty() || !(selectedObjects.get(0) instanceof EditPart)) {
            return Collections.emptyList();
        }
        return selectedObjects;
    }

    protected ISelection getSelection() {
        return this.selection;
    }

    protected void handleSelectionChanged() {
        this.refresh();
    }

    protected void setSelection(ISelection selection) {
        this.selection = selection;
        this.handleSelectionChanged();
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.provider = provider;
    }

    @Override
    public void update() {
        if (this.provider != null) {
            this.setSelection(this.provider.getSelection());
        } else {
            this.setSelection(this.getWorkbenchPart().getSite().getWorkbenchWindow().getSelectionService().getSelection());
        }
    }
}

