/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.rulers;

import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.AccessibleHandleProvider;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.internal.ui.rulers.DragGuidePolicy;
import org.eclipse.gef.internal.ui.rulers.GuideFigure;
import org.eclipse.gef.internal.ui.rulers.RulerEditPart;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Cursor;

public class GuideEditPart
extends AbstractGraphicalEditPart {
    public static final int MIN_DISTANCE_BW_GUIDES = 5;
    public static final int DELETE_THRESHOLD = 20;
    private AccessibleEditPart accPart;
    private GuideLineFigure guideLineFig;
    private Cursor cursor = null;
    private final ZoomListener zoomListener = zoom -> this.handleZoomChanged();
    private final RulerChangeListener listener = new RulerChangeListener.Stub(){

        @Override
        public void notifyGuideMoved(Object guide) {
            if (GuideEditPart.this.getModel() == guide) {
                GuideEditPart.this.handleGuideMoved();
            }
        }

        @Override
        public void notifyPartAttachmentChanged(Object part, Object guide) {
            if (GuideEditPart.this.getModel() == guide) {
                GuideEditPart.this.handlePartAttachmentChanged(part);
            }
        }
    };

    public GuideEditPart(Object model) {
        this.setModel(model);
    }

    @Override
    public void activate() {
        super.activate();
        this.getRulerProvider().addRulerChangeListener(this.listener);
        if (this.getZoomManager() != null) {
            this.getZoomManager().addZoomListener(this.zoomListener);
        }
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", new GuideSelectionPolicy());
        this.installEditPolicy("PrimaryDrag Policy", new DragGuidePolicy());
    }

    @Override
    protected IFigure createFigure() {
        this.guideLineFig = new GuideLineFigure();
        this.getGuideLayer().add(this.getGuideLineFigure());
        this.getGuideLayer().setConstraint(this.getGuideLineFigure(), (Object)this.isHorizontal());
        return new GuideFigure(this.isHorizontal());
    }

    @Override
    public void deactivate() {
        if (this.getZoomManager() != null) {
            this.getZoomManager().removeZoomListener(this.zoomListener);
        }
        this.getRulerProvider().removeRulerChangeListener(this.listener);
        if (this.getGuideLineFigure().getParent() != null) {
            this.getGuideLineFigure().getParent().remove(this.getGuideLineFigure());
        }
        super.deactivate();
    }

    @Override
    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accPart == null) {
            this.accPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                @Override
                public void getDescription(AccessibleEvent e) {
                    if (GuideEditPart.this.getRulerProvider() != null) {
                        GuideEditPart.this.getRulerProvider().getAccGuideDescription(e, GuideEditPart.this.getModel());
                    }
                }

                @Override
                public void getName(AccessibleEvent e) {
                    if (GuideEditPart.this.getRulerProvider() != null) {
                        GuideEditPart.this.getRulerProvider().getAccGuideName(e, GuideEditPart.this.getModel());
                    }
                }

                @Override
                public void getValue(AccessibleControlEvent e) {
                    if (GuideEditPart.this.getRulerProvider() != null) {
                        GuideEditPart.this.getRulerProvider().getAccGuideValue(e, GuideEditPart.this.getModel());
                    }
                }
            };
        }
        return this.accPart;
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        if (key == AccessibleHandleProvider.class) {
            return key.cast(() -> {
                ArrayList<Point> result = new ArrayList<Point>();
                Point pt = this.getFigure().getBounds().getCenter();
                this.getFigure().translateToAbsolute((Translatable)pt);
                result.add(pt);
                return result;
            });
        }
        return super.getAdapter(key);
    }

    public Cursor getCurrentCursor() {
        if (this.cursor == null) {
            return this.getFigure().getCursor();
        }
        return this.cursor;
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker(this){

            @Override
            protected Cursor calculateCursor() {
                if (this.isInState(8)) {
                    return Cursors.NO;
                }
                return GuideEditPart.this.getCurrentCursor();
            }

            @Override
            protected boolean isMove() {
                return true;
            }
        };
    }

    public IFigure getGuideLayer() {
        return this.getParent().getGuideLayer();
    }

    public IFigure getGuideLineFigure() {
        return this.guideLineFig;
    }

    @Override
    public RulerEditPart getParent() {
        return (RulerEditPart)super.getParent();
    }

    public RulerProvider getRulerProvider() {
        return this.getParent().getRulerProvider();
    }

    public int getZoomedPosition() {
        double position = this.getRulerProvider().getGuidePosition(this.getModel());
        if (this.getZoomManager() != null) {
            position = Math.round(position * this.getZoomManager().getZoom());
        }
        return (int)position;
    }

    public ZoomManager getZoomManager() {
        return this.getParent().getZoomManager();
    }

    protected void handleGuideMoved() {
        this.refreshVisuals();
    }

    protected void handlePartAttachmentChanged(Object part) {
    }

    protected void handleZoomChanged() {
        this.refreshVisuals();
    }

    public boolean isHorizontal() {
        return !this.getParent().isHorizontal();
    }

    @Override
    protected void refreshVisuals() {
        this.updateLocationOfFigures(this.getZoomedPosition());
    }

    @Override
    public void removeNotify() {
        AbstractGraphicalEditPart nextSelection = null;
        if (this.getParent().isActive()) {
            int thisPos = this.getRulerProvider().getGuidePosition(this.getModel());
            if (this.getSelected() != 0 || this.hasFocus()) {
                int minDistance = -1;
                for (GuideEditPart guideEditPart : this.getParent().getChildren()) {
                    if (guideEditPart == this) continue;
                    int posDiff = Math.abs(thisPos - this.getRulerProvider().getGuidePosition(guideEditPart.getModel()));
                    if (minDistance != -1 && posDiff >= minDistance) continue;
                    minDistance = posDiff;
                    nextSelection = guideEditPart;
                }
                if (nextSelection == null) {
                    nextSelection = this.getParent();
                }
            }
        }
        super.removeNotify();
        if (nextSelection != null) {
            this.getViewer().select(nextSelection);
        }
    }

    public void setCurrentCursor(Cursor c) {
        this.cursor = c;
    }

    public void updateLocationOfFigures(int position) {
        this.getParent().setLayoutConstraint(this, this.getFigure(), position);
        Point guideFeedbackLocation = this.getGuideLineFigure().getBounds().getLocation();
        if (this.isHorizontal()) {
            guideFeedbackLocation.y = position;
        } else {
            guideFeedbackLocation.x = position;
        }
        this.getGuideLineFigure().setLocation(guideFeedbackLocation);
        this.getGuideLineFigure().revalidate();
    }

    public static class GuideLineFigure
    extends Figure {
        public GuideLineFigure() {
            this.setPreferredSize(1, 1);
        }

        protected void paintFigure(Graphics g) {
            g.setLineStyle(3);
            g.setXORMode(true);
            g.setForegroundColor(ColorConstants.darkGray);
            if (this.bounds.width > this.bounds.height) {
                g.drawLine(this.bounds.x, this.bounds.y, this.bounds.right(), this.bounds.y);
                g.drawLine(this.bounds.x + 2, this.bounds.y, this.bounds.right(), this.bounds.y);
            } else {
                g.drawLine(this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.bottom());
                g.drawLine(this.bounds.x, this.bounds.y + 2, this.bounds.x, this.bounds.bottom());
            }
        }
    }

    public static class GuideSelectionPolicy
    extends SelectionEditPolicy {
        @Override
        protected void hideFocus() {
            ((GuideFigure)this.getHostFigure()).setDrawFocus(false);
        }

        @Override
        protected void hideSelection() {
            ((GuideFigure)this.getHostFigure()).setDrawFocus(false);
        }

        @Override
        protected void showFocus() {
            ((GuideFigure)this.getHostFigure()).setDrawFocus(true);
        }

        @Override
        protected void showSelection() {
            ((GuideFigure)this.getHostFigure()).setDrawFocus(true);
        }
    }
}

