/*! @azure/msal-browser v4.26.1 2025-11-06 */
'use strict';
import { SignInSubmitCodeError } from '../error_type/SignInError.mjs';
import { SignInFailedState } from '../state/SignInFailedState.mjs';
import { AuthFlowResultBase } from '../../../core/auth_flow/AuthFlowResultBase.mjs';
import { SIGN_IN_FAILED_STATE_TYPE, SIGN_IN_COMPLETED_STATE_TYPE, AUTH_METHOD_REGISTRATION_REQUIRED_STATE_TYPE, MFA_AWAITING_STATE_TYPE } from '../../../core/auth_flow/AuthFlowStateTypes.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/*
 * Result of a sign-in submit code operation.
 */
class SignInSubmitCodeResult extends AuthFlowResultBase {
    /**
     * Creates a new instance of SignInSubmitCodeResult with error data.
     * @param error The error that occurred.
     * @returns {SignInSubmitCodeResult} A new instance of SignInSubmitCodeResult with the error set.
     */
    static createWithError(error) {
        const result = new SignInSubmitCodeResult(new SignInFailedState());
        result.error = new SignInSubmitCodeError(SignInSubmitCodeResult.createErrorData(error));
        return result;
    }
    /**
     * Checks if the result is in a failed state.
     */
    isFailed() {
        return this.state.stateType === SIGN_IN_FAILED_STATE_TYPE;
    }
    /**
     * Checks if the result is in a completed state.
     */
    isCompleted() {
        return this.state.stateType === SIGN_IN_COMPLETED_STATE_TYPE;
    }
    /**
     * Checks if the result requires authentication method registration.
     * @warning This API is experimental. It may be changed in the future without notice. Do not use in production applications.
     */
    isAuthMethodRegistrationRequired() {
        return (this.state.stateType ===
            AUTH_METHOD_REGISTRATION_REQUIRED_STATE_TYPE);
    }
    /**
     * Checks if the result requires MFA.
     * @warning This API is experimental. It may be changed in the future without notice. Do not use in production applications.
     */
    isMfaRequired() {
        return this.state.stateType === MFA_AWAITING_STATE_TYPE;
    }
}

export { SignInSubmitCodeResult };
//# sourceMappingURL=SignInSubmitCodeResult.mjs.map
