﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanroomsml/CleanRoomsMLRequest.h>
#include <aws/cleanroomsml/CleanRoomsML_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace CleanRoomsML {
namespace Model {

/**
 */
class GetCollaborationTrainedModelRequest : public CleanRoomsMLRequest {
 public:
  AWS_CLEANROOMSML_API GetCollaborationTrainedModelRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetCollaborationTrainedModel"; }

  AWS_CLEANROOMSML_API Aws::String SerializePayload() const override;

  AWS_CLEANROOMSML_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the trained model that you want to return
   * information about.</p>
   */
  inline const Aws::String& GetTrainedModelArn() const { return m_trainedModelArn; }
  inline bool TrainedModelArnHasBeenSet() const { return m_trainedModelArnHasBeenSet; }
  template <typename TrainedModelArnT = Aws::String>
  void SetTrainedModelArn(TrainedModelArnT&& value) {
    m_trainedModelArnHasBeenSet = true;
    m_trainedModelArn = std::forward<TrainedModelArnT>(value);
  }
  template <typename TrainedModelArnT = Aws::String>
  GetCollaborationTrainedModelRequest& WithTrainedModelArn(TrainedModelArnT&& value) {
    SetTrainedModelArn(std::forward<TrainedModelArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The collaboration ID that contains the trained model that you want to return
   * information about.</p>
   */
  inline const Aws::String& GetCollaborationIdentifier() const { return m_collaborationIdentifier; }
  inline bool CollaborationIdentifierHasBeenSet() const { return m_collaborationIdentifierHasBeenSet; }
  template <typename CollaborationIdentifierT = Aws::String>
  void SetCollaborationIdentifier(CollaborationIdentifierT&& value) {
    m_collaborationIdentifierHasBeenSet = true;
    m_collaborationIdentifier = std::forward<CollaborationIdentifierT>(value);
  }
  template <typename CollaborationIdentifierT = Aws::String>
  GetCollaborationTrainedModelRequest& WithCollaborationIdentifier(CollaborationIdentifierT&& value) {
    SetCollaborationIdentifier(std::forward<CollaborationIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version identifier of the trained model to retrieve. If not specified,
   * the operation returns information about the latest version of the trained
   * model.</p>
   */
  inline const Aws::String& GetVersionIdentifier() const { return m_versionIdentifier; }
  inline bool VersionIdentifierHasBeenSet() const { return m_versionIdentifierHasBeenSet; }
  template <typename VersionIdentifierT = Aws::String>
  void SetVersionIdentifier(VersionIdentifierT&& value) {
    m_versionIdentifierHasBeenSet = true;
    m_versionIdentifier = std::forward<VersionIdentifierT>(value);
  }
  template <typename VersionIdentifierT = Aws::String>
  GetCollaborationTrainedModelRequest& WithVersionIdentifier(VersionIdentifierT&& value) {
    SetVersionIdentifier(std::forward<VersionIdentifierT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_trainedModelArn;

  Aws::String m_collaborationIdentifier;

  Aws::String m_versionIdentifier;
  bool m_trainedModelArnHasBeenSet = false;
  bool m_collaborationIdentifierHasBeenSet = false;
  bool m_versionIdentifierHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRoomsML
}  // namespace Aws
