﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock/Bedrock_EXPORTS.h>
#include <aws/bedrock/model/AutomatedReasoningPolicyDefinition.h>
#include <aws/bedrock/model/AutomatedReasoningPolicyDefinitionQualityReport.h>
#include <aws/bedrock/model/AutomatedReasoningPolicyBuildLog.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Bedrock
{
namespace Model
{

  /**
   * <p>Contains the various assets generated during a policy build workflow,
   * including logs, quality reports, and the final policy definition.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/AutomatedReasoningPolicyBuildResultAssets">AWS
   * API Reference</a></p>
   */
  class AutomatedReasoningPolicyBuildResultAssets
  {
  public:
    AWS_BEDROCK_API AutomatedReasoningPolicyBuildResultAssets() = default;
    AWS_BEDROCK_API AutomatedReasoningPolicyBuildResultAssets(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCK_API AutomatedReasoningPolicyBuildResultAssets& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCK_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The complete policy definition generated by the build workflow, containing
     * all rules, variables, and custom types extracted from the source documents.</p>
     */
    inline const AutomatedReasoningPolicyDefinition& GetPolicyDefinition() const { return m_policyDefinition; }
    inline bool PolicyDefinitionHasBeenSet() const { return m_policyDefinitionHasBeenSet; }
    template<typename PolicyDefinitionT = AutomatedReasoningPolicyDefinition>
    void SetPolicyDefinition(PolicyDefinitionT&& value) { m_policyDefinitionHasBeenSet = true; m_policyDefinition = std::forward<PolicyDefinitionT>(value); }
    template<typename PolicyDefinitionT = AutomatedReasoningPolicyDefinition>
    AutomatedReasoningPolicyBuildResultAssets& WithPolicyDefinition(PolicyDefinitionT&& value) { SetPolicyDefinition(std::forward<PolicyDefinitionT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A comprehensive report analyzing the quality of the generated policy,
     * including metrics about rule coverage, potential conflicts, and unused
     * elements.</p>
     */
    inline const AutomatedReasoningPolicyDefinitionQualityReport& GetQualityReport() const { return m_qualityReport; }
    inline bool QualityReportHasBeenSet() const { return m_qualityReportHasBeenSet; }
    template<typename QualityReportT = AutomatedReasoningPolicyDefinitionQualityReport>
    void SetQualityReport(QualityReportT&& value) { m_qualityReportHasBeenSet = true; m_qualityReport = std::forward<QualityReportT>(value); }
    template<typename QualityReportT = AutomatedReasoningPolicyDefinitionQualityReport>
    AutomatedReasoningPolicyBuildResultAssets& WithQualityReport(QualityReportT&& value) { SetQualityReport(std::forward<QualityReportT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The complete build log containing detailed information about each step in the
     * policy generation process.</p>
     */
    inline const AutomatedReasoningPolicyBuildLog& GetBuildLog() const { return m_buildLog; }
    inline bool BuildLogHasBeenSet() const { return m_buildLogHasBeenSet; }
    template<typename BuildLogT = AutomatedReasoningPolicyBuildLog>
    void SetBuildLog(BuildLogT&& value) { m_buildLogHasBeenSet = true; m_buildLog = std::forward<BuildLogT>(value); }
    template<typename BuildLogT = AutomatedReasoningPolicyBuildLog>
    AutomatedReasoningPolicyBuildResultAssets& WithBuildLog(BuildLogT&& value) { SetBuildLog(std::forward<BuildLogT>(value)); return *this;}
    ///@}
  private:

    AutomatedReasoningPolicyDefinition m_policyDefinition;
    bool m_policyDefinitionHasBeenSet = false;

    AutomatedReasoningPolicyDefinitionQualityReport m_qualityReport;
    bool m_qualityReportHasBeenSet = false;

    AutomatedReasoningPolicyBuildLog m_buildLog;
    bool m_buildLogHasBeenSet = false;
  };

} // namespace Model
} // namespace Bedrock
} // namespace Aws
